<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die ('Restricted access');
JLoader::register('K2Plugin', JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'lib'.DS.'k2plugin.php');

class plgK2K2Store extends K2Plugin {

	// Some params
	var $pluginName = 'k2store';
	var $pluginNameHumanReadable = 'K2 Store';

	function plgK2K2Store( & $subject, $params) {
	
		parent::__construct($subject, $params);
	}
	
	function onK2PrepareContent( & $item, & $params, $limitstart) {
	
	}
	
	function onK2AfterDisplay( & $item, & $params, $limitstart) {
	
		global $mainframe;
		$lang = JFactory::getLanguage();
		$lang->load('com_k2store');
		
		$plugins = new K2Parameter($item->plugins, '', $this->pluginName);
		$item_price = $plugins->get('item_price');
		if ($item_price) {
			
			 $doc = &JFactory::getDocument();
			 $doc->addStyleSheet(JURI::base().'components'.DS.'com_k2store'.DS.'css'.DS.'style.css');
			 
		// utility to prevent multiple inclusion of the add to cart javascript - added june 20, 2010
		
			$uri =& JURI::getInstance();
			$headData = false;
			// getting module head section datas
			unset($headData);
			$headData = $doc->getHeadData();
			// generate keys of script section
			$headData_keys = array_keys($headData["scripts"]);
			// set variable for false
			$script_found = false;
			// searching phrase k2store in scripts paths
			if(array_search($uri->root().'components/com_k2store/js/k2store.js', $headData_keys) > 0) $script_found = true;
			// if k2store file doesn't exists in document head section
			if(!$script_found){ 
				// add new script tag 
				$headData["scripts"][$uri->root().'components/com_k2store/js/k2store.js'] = "text/javascript";
				$doc->setHeadData($headData);
			}
		
					
			$content = $this->addtoCart($item);
			
		} else {
			$content = '';
			
		}
		return $content;
	}
	
	function onK2AfterDisplayContent( & $item, & $params, $limitstart) {
	
		global $mainframe;
		
		//get component params
		$params = &JComponentHelper::getParams('com_k2store');
		
		//get plugin params
		$plugins = new K2Parameter($item->plugins, '', $this->pluginName);
		$item_price = $plugins->get('item_price');
	
		if ( empty($item_price)) return;
		
		if($params->get('show_itemprice')) {
			if ($item_price) {
				$output ='<div class="k2store_item_price"><span class="item_price_label">'.JText::_('Item Price').' : </span><span class="k2store_item_price_value">&nbsp;'.$params->get('currency').$item_price.'</span></div>';
			}
		}	
	
		return $output;
	}	
	
 function addtoCart(&$item) {
	 
		$user 	=& JFactory::getUser();
		
		//get component params
		$params = &JComponentHelper::getParams('com_k2store');
		
		//get plugin params		
		
		$plugins = new K2Parameter($item->plugins, '', $this->pluginName);
		$item_price = $plugins->get('item_price');		
		
		$Itemid = $params->get('itemid');
		
		$link = JRoute::_('index.php?option=com_k2store&view=mycart&Itemid='.$Itemid);
		$currency = $params->get('currency');
		$add_to_cart_text = JText::_('ADD TO CART');
		$checkout_text = JText::_('SHOWCART');
	
		//build the cart buttons
		
			if ($item) {
				
				if ($item_price){
					$cart = "<div class=\"mycart\">";
					$cart .="<form id=\"cart_form\" class=\"cart_form\" action=\"index.php?option=com_k2store&view=mycart&format=ajax&order_code=$item->id\" method=\"post\">";
					$cart .="<input type=\"hidden\" name=\"option\" value=\"com_k2store\" />";
					$cart .="<input type=\"hidden\" name=\"task\" value=\"cartaction\" />";
					$cart .="<input type=\"hidden\" name=\"Itemid\" value=\"$Itemid\" />";
					$cart .="<input type=\"hidden\" id=\"order_code\" name=\"order_code\" value=\"$item->id\" />";
					$cart .="<label><b> $item->title : </b> <input class=\"center\" type=\"text\" id=\"quantity\" name=\"quantity\" value=\"1\" size=\"3\" /></label>";
					$cart .="<label><b> $currency </b> $item_price </label>";
					$cart .="<input type=\"submit\" name=\"submit\" value=\"$add_to_cart_text\" />";
					$cart .="&nbsp;&nbsp;&nbsp;";
					$cart .= "<input type=\"button\" value=\"$checkout_text \" onclick=\"window.location = '$link'\"/>";
					$cart .="</form>";
					$cart .="</div>";
				}	
			}	
							
	return $cart;
	
}	

	
} // END CLASS