<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport('joomla.application.component.view');

class ViewQuotes extends JView {
    
    public function display($tpl = null) {
        
        $model      =   $this->getModel();
        $layout     =   $this->getLayout();
        
        switch ( $layout ) {
            
            case "form":
            
		        /**
		         *  Check for currect user
		         */
		        $userId =  JFactory::getUser()->get("id");
		        if ( !$userId ) {
		            JError::raiseWarning(500, JText::_('You are not authorized.'));
		            $app = JFactory::getApplication();
		            $app->redirect(JRoute::_('index.php?option=com_user&view=login'));
		        }
		        
                // Get task
                $task       =   JRequest::getVar("task","add",null,"string");
                
                if ( strcmp("edit",$task) == 0 ) { // Editing quote
                    
                    $cid    =   JRequest::getVar( 'cid', array(),null, 'array' );
                    JArrayHelper::toInteger($cid);
                    
                    // Get manufacture data
                    if ( !empty( $cid[0] ) ) {
                        
                        JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');
                        $row = JTable::getInstance('Quotes', 'Table');
                        
                        $row->id = (int)$cid[0];
                        $row->user_id   =   JFactory::getUser()->get("id");
                        $row->published =   1;
                        
                        if (!$row->load())  {
                            
                            $log    =   JLog::getInstance();
                            $log->addEntry(array("status"=>"Error", "comment"=> " Error Message : Can't load quote data." ));
                            JError::raiseError(500, JText::_("System error!"));
                             
                        }
                        
                    } else {
                        
                        JError::raiseError(500, JText::_( 'Select quote, please!', true ) );
                    }
                    
                    $this->assignRef('item', $row);
                } else {
                	$this->assign('author', JFactory::getUser()->get('name') );
                }
                
                // add the JavaScript
                JHTML::_('behavior.formvalidation');

                $app = JFactory::getApplication();
                $app->setUserState("redirect.view", $this->getName());
                $app->setUserState("redirect.layout", $this->getLayout());
            
            break;
            
            // Quote listing
            default:

            	// Add styles
                $document       = JFactory::getDocument();
                $document->addStyleSheet( JURI::base() . 'components/com_vipquotes/vip_quotes.css', 'text/css', null, array( 'id' => 'VipQuotesStyleSheet' ) );
             
            	// Get component parameters
                $app            =  JFactory::getApplication();
                $params         =  $app->getParams('com_vipquotes');
                
                $pagination     =  $this->get( 'Pagination' );
                
                $this->assign('userId',         JFactory::getUser()->get("id"));
                $this->assignRef('pagination',  $pagination);
                $this->assignRef('items',       $model->getData());
                $this->assignRef('params',      $params);
                
                $this->assign('q',      JRequest::getVar('q',''));
                $this->assign('search_by', JRequest::getVar('search_by','author'));
                
            break;
        }
        
        // Load a JEditor object
        $editor = JFactory::getEditor();
        $this->assignRef('editor',  $editor);
                
        $modelCategories  =   JModel::getInstance("Categories","Model");
        $this->assignRef("categories",$modelCategories->getCategories());
        
        parent::display($tpl);
    }
    
    
}
?>