<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class VipQuotesController extends JController {
    
    function __construct($config = array()) {
	    
		parent::__construct($config);

//		 Register Extra tasks
		$this->registerTask( 'add' , 'display' );
		$this->registerTask( 'edit', 'display' );
		
		// use the same models as the back-end
		$path = JPATH_COMPONENT_ADMINISTRATOR.DS.'models';
		$this->addModelPath($path);
		
	}
	
    public function display() {

        $document =& JFactory::getDocument();
        
        /* @var $document JDocument */
        $viewType = $document->getType();

        // Set add and edit task parameters
        switch($this->getTask())
		{
			case 'add'     :
			{
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
//				JRequest::setVar( 'view'  , 'new');

			} 
			break;
			case 'edit'    :
			{
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );
//				JRequest::setVar( 'view'  , 'edit');

			} 
			break;
			
		}
        
		// Get layout value
        $viewLayout =   JRequest::getVar('layout', 'default');
        // Get view value
        $viewName   =   JRequest::getVar('view', 'quotes');
        
        // Get view
        $view = &$this->getView( $viewName, $viewType, "View" );
        /* @var $view JView */
        
        // Get model
        $model =&   $this->getModel( $viewName, 'Model' );
        if (!JError::isError( $model ) ) {
            $view->setModel( $model, true );
        }
        
        // Set layout into view 
        $view->setLayout($viewLayout);
        
        // Display view
        $view->display();
        
    }

    
    public function save() {
	    
    	/**
         *  Check for currect user
         */
    	$userId =  JFactory::getUser()->get("id");
    	if ( !$userId ) {
    		JError::raiseError(500,JText::_("You are not authorized."));
    	}

    	// Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
			JError::raiseError('403', JText::_('Request Forbidden'));
		}

	    // Get view name
        $viewName  =   JRequest::getVar('view', '');
        
        if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist"));
        }
        
        JRequest::setVar("published",0);
        
        $model =& $this->getModel($viewName, "Model");

        if ( !JError::isError( $model->store() ) ) {
        	
	        // Send mail to administrator
	        $app    =   JFactory::getApplication();
	        $params =   $app->getParams('com_vipquotes');
	        
	        $config =   JFactory::getConfig();
	        
	        if ( (bool)$params->get("sendMail") ) {
	            
	            $mail   =   JFactory::getMailer();
	            
	            $mail->setSubject(JText::_("New quote"));
	            
	            $mail->setSender($config->getValue("mailfrom"));
	            $mail->addRecipient($config->getValue("mailfrom"));
	            
	            $body   =   JText::_("There is a new quote.");
	            
	            $mail->isHTML(false);
	            $mail->setBody($body);
	            
	            $mail->send();
	            
	        }
	        
        } else {
        	// Back to quote form
            $referer = JRequest::getVar("HTTP_REFERER",'','SERVER');
            if ( !$referer ) {
                $referer = JRoute::_( 'index.php?option=com_vipquotes&view=quotes');
            }
            $this->setRedirect( $referer );
            return;
        }
        
        // Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
	}

	/**
	 * Facebook application serivice
	 * @todo Implementation
	 */
	public function service() {
		
		return;
		
		// Get component parameters
        $app            =  JFactory::getApplication();
        $params         =  $app->getParams('com_vipquotes');

        if ( !$params->get("serviceEnabled") ) {
        	echo JText::_("The service is not available.");
        }
        
        require ( JPATH_COMPONENT_ADMINISTRATOR . DS . "libraries" . DS . "facebook.php" );
        
        $fbSettings = array(
          'appId'  => $params->get("fbApiKey"),
          'secret' => $params->get("fbSecretKey"),
          'cookie' => true,
        );
        
        // Create our Application instance.
		$facebook = new Facebook($fbSettings);
		
		// We may or may not have this data based on a $_GET or $_COOKIE based session.
		//
		// If we get a session here, it means we found a correctly signed session using
		// the Application Secret only Facebook and the Application know. We dont know
		// if it is still valid until we make an API call using the session. A session
		// can become invalid if it has already expired (should not be getting the
		// session back in this case) or if the user logged out of Facebook.
		$session = $facebook->getSession();
		
		dump($session,"FB session");
		$me = null;
		// Session based API call.
		if ($session) {
		  try {
		    $uid = $facebook->getUser();
		    $me = $facebook->api('/tosho.iliev');
		  } catch (FacebookApiException $e) {
		    
            dump($e,"exception");
            return;
		  	
		  }
		}
		
		// login or logout url will be needed depending on current user state.
		if ($me) {
            dump($me,"exception");
            $logoutUrl = $facebook->getLogoutUrl();
		} else {
            $loginUrl = $facebook->getLoginUrl();
		}
		
		// This call will always work since we are fetching public data.
		$todor = $facebook->api('/tosho.iliev');
		dump($todor,"Todor");
	}
	
}

?>