<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model');

JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables');

class K2StoreModelBilling extends JModel {
	
	 function getData($ordering = NULL) {
		 
	 }
	 
	 
	 function saveOrder($payment_type, $user_id) {
		 
		 //initialise variables
		$date =& JFactory::getDate();
		$session = JFactory::getSession();
		$cart = $session->get('shopping_cart');
		
		if(empty($cart)) {
			return false;
		}
		
		$order_id = time();
	
		require_once(JPATH_SITE.DS.'components'.DS.'com_k2store'.DS.'helpers'.DS.'cart.php');
		
		foreach ($cart as $itemid=>$quantity) {
			
			$item_price = (double) K2StoreHelperCart::getItemPrice($itemid);
			$total = $quantity*$item_price;
			
			$row	=& JTable::getInstance('orderdetails', 'Table');
			$row->user_id = $user_id;
			$row->order_date = $date->toMySQL();
			$row->order_id = $order_id;
			$row->itemid = $itemid;
			$row->itemname = K2StoreHelperCart::getItemName($itemid);
			$row->itemprice = $item_price;
			$row->quantity = $quantity;
			$row->total = $total;
			//$row->order_status = JText::_('PENDING');
			
				// pre-save checks
				if (!$row->check()) {
					JError::raiseError(500, $row->getError() );
				}
			
				// if new item,  last in appropriate group
				if (!$row->id) {
					$where = "id = " . (int) $row->id;		
				}
								
				// save the changes
				if (!$row->store()) {
					JError::raiseError(500, $row->getError() );
				}
				
			$order_total += $total;	
					
		}
		
		$table = JTable::getInstance('Orders', 'Table');	
		$table->order_id = $order_id;
		$table->user_id = $user_id;
		$table->orderpayment_type = $payment_type; // this is the payment plugin selected
		$table->transaction_status = JText::_( "Incomplete" ); // payment plugin updates this field onPostPayment
		$table->orderpayment_amount = $order_total;

		
		// pre-save checks
				if (!$table->check()) {
					JError::raiseError(500, $table->getError() );
				}
			
				// if new item,  last in appropriate group
				if (!$table->id) {
					$where = "id = " . (int) $table->id;		
				}
								
				// save the changes
				if (!$table->store()) {
					JError::raiseError(500, $table->getError() );
					return false;
				}
		
		return $table->id;
		 
	 }
	 
	 
	 function checkShippingAddress() {
		 
		$user =	& JFactory::getUser();
		$db = &JFactory::getDBO();
		
		$query = "SELECT * FROM #__k2store_address WHERE user_id={$user->id}";
		$db->setQuery($query);
		return $db->loadObject();
		 
	 }
	 
	 function getSavedOrder($id) {
		 
		$user =	& JFactory::getUser();
		$db = &JFactory::getDBO();
		
		$query = "SELECT * FROM #__k2store_orders WHERE id={$id}";
		$db->setQuery($query);
		return $db->loadObject();
		 
	 }
	 
	
}