<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class K2StoreControllerCheckout extends JController
{
	
	function display() {
		$mainframe = &JFactory::getApplication();
		$user 		=	& JFactory::getUser();
		$guest = JRequest::getVar( 'guest', '0' );
		$address_edit = JRequest::getVar( 'address_edit', '0' );
		$params = &JComponentHelper::getParams('com_k2store');
		
		JRequest::setVar('view', 'checkout');
		
		if($guest == '1')
			$guest = true;
		else 
			$guest = false;
		
		if (empty($user->id) && !$guest)
		{
			// Display a form for selecting either to register or to login
			JRequest::setVar('layout', 'form');
			
		} 
		else if(empty($user->id) && $guest && $params->get('allow_guest_checkout'))
		{
			$html = $this->getOrderSummary();			
			$view = $this->getView( 'checkout', 'html' );
			$view->set( 'hidemenu', false);
			$view->assign( 'orderSummary', $html );			
			JRequest::setVar('layout', 'guest');
			
		}
		// Already Logged in, a traditional checkout
		else
		{		
			require_once(JPATH_COMPONENT.DS.'helpers'.DS.'shopping_cart.class.php');
			$Cart = new Shopping_Cart('shopping_cart');
			//redirect if there are no items in the cart
			if(count($Cart->getItems()) < 1 ) {
				$link = JRoute::_('index.php?option=com_k2store');
				$msg = JText::_('No items in the cart');
				$mainframe->redirect($link, $msg);
			}
			
			$html = $this->getOrderSummary();		
			
			$model		= &$this->getModel('checkout');
			$address = $model->checkShippingAddress();
			
			
			$view = $this->getView( 'checkout', 'html' );
			$view->set( 'hidemenu', false);
			$view->assign( 'address', $address );
			$view->assign( 'orderSummary', $html );			
		
			if ($address) {
				JRequest::setVar('layout', 'default');
			} else {
				JRequest::setVar('layout', 'address');
			}					
		
		}
		
		if($address_edit) {			
			JRequest::setVar('layout', 'address');
		} 	
		
		parent::display();		
	}

function getOrderSummary()
	{

	    $params = &JComponentHelper::getParams('com_k2store');
		$model = $this->getModel('mycart');
		$view = $this->getView( 'mycart', 'html' );	
		$view->set( '_view', 'mycart' );
		$view->set( '_doTask', true);
		$view->set( 'hidemenu', true);
		$view->setModel( $model, true );
		$view->assign( 'items', $model->get('Data'));
		$view->assign( 'params', $params );
		$view->assign( 'summary', true );
		$view->setLayout( 'ajax' );

		ob_start();
		$view->display();
		$html = ob_get_contents();
		ob_end_clean();

		return $html;
	}
	

function save()
	{
		$mainframe = &JFactory::getApplication();
		JRequest::checkToken() or jexit('Invalid Token');
		$post = JRequest::get('post');	   
		$type = JRequest::getWord('savetype', 'order');
		$model = $this->getModel($type);
		$model->save($post);
		$link = JRoute::_('index.php?option=com_k2store&view=billing');
		$msg = JText::_('Shipping address saved sucessfully');
		$mainframe->redirect($link, $msg);		
	}
	
	
function guestsave() {
	
		$mainframe = &JFactory::getApplication();
		JRequest::checkToken() or jexit('Invalid Token');
		$session = JFactory::getSession();
		
		$guest = JRequest::getVar( 'guest', '0' );
		
		if ($guest != 1) {
			
			$link = JRoute::_('index.php?option=com_k2store&view=mycart');
			$msg = JText::_('Only guests are allowed to checkout this way');
			$mainframe->redirect($link, $msg);
			
		}
		
		//get post vars
		
		$post = JRequest::get('post');
		
		//validate captcha
		
		if ($post['captcha'] != $session->get('expect')) {
		
			$link = JRoute::_('index.php?option=com_k2store&view=checkout&guest=1');
			$msg = JText::_('Wrong captcha');
			$mainframe->redirect($link, $msg);				
			
		}
		
		
		if(empty($post['first_name']) || empty($post['last_name']) || empty($post['email_address']) || empty($post['address_1']) || empty($post['city']) || empty($post['zip']) || empty($post['state']) || empty($post['country']) || empty($post['phone_1']) )  {
			
			$link = JRoute::_('index.php?option=com_k2store&view=checkout&guest=1');
			$msg = JText::_('All fields are required');
			$mainframe->redirect($link, $msg);
			
		}
		
		
		$session->set('guestaddress', $post);
		$session->set('isguest', 1);
		
		$link = JRoute::_('index.php?option=com_k2store&view=billing');
	//	$msg = JText::_('Shipping address saved sucessfully');
		$mainframe->redirect($link);		
		
 }	
	
}
?>