<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class K2StoreControllerBilling extends JController
{
	
	function display() {
		$mainframe = &JFactory::getApplication();
		$user 		=	& JFactory::getUser();
		$session = JFactory::getSession();
		$guest = $session->get('isguest');
		$params = &JComponentHelper::getParams('com_k2store');
		
		$guest_address = $session->get('guestaddress');
		
		//if user is guest, let is create a silent login for him.
		if($guest && !$user->id && $params->get('allow_guest_checkout')) {
				
			require_once (JPATH_COMPONENT_ADMINISTRATOR.DS.'library'.DS.'user.php');	
			$userHelper = new K2StoreHelperUser;
				
			if ($userHelper->emailExists($guest_address['email_address']))
			{
				//user already exists
				
				$link = JRoute::_('index.php?option=com_k2store&view=checkout&guest=1');
				$msg = JText::_('Email already exists');
				$mainframe->redirect($link, $msg);
				
			} 
                else
			{
				// create the details array with new user info
				$details = array(
					'email' => $guest_address['email_address'],
					'name' => $guest_address['first_name'],
					'username' => $guest_address['email_address']			
				);
				
				// use a random password, and send password2 for the email
				jimport('joomla.user.helper');
                $details['password']    = JUserHelper::genRandomPassword();
                $details['password2']   = $details['password'];

				$msg = $this->getError();

				$user = $userHelper->createNewUser($details, $msg);


				$userHelper->login( 
				    array('username' => $user->username, 'password' => $user->password_clear) 
				);
				
				if (empty($user->id))
				{
					// what to do if creating new user failed?
					
					$link = JRoute::_('index.php?option=com_k2store&view=checkout&guest=1');
					$msg = JText::_('User creation failed. Try again to checkout');
					$mainframe->redirect($link, $msg);
					
				}
				
			}
			
			// now logged in. Let us save the address values
			if($user->id) {
				$model1 = $this->getModel('address');
				$success = $model1->save($guest_address);
				
				// redirect the user to checkout again as address saving is failed.
				if(!$success) {
				
					$link = JRoute::_('index.php?option=com_k2store&view=checkout');
					$msg = JText::_('Problem in saving address');
					$mainframe->redirect($link, $msg);	
					
				}
			
			}
			
		} 
			
			require_once(JPATH_COMPONENT.DS.'helpers'.DS.'shopping_cart.class.php');
			$Cart = new Shopping_Cart('shopping_cart');
			//redirect if there are no items in the cart
	
			if(count($Cart->getItems()) < 1 ) {
				$link = JRoute::_('index.php?option=com_k2store');
				$msg = JText::_('No items in the cart');
				$mainframe->redirect($link, $msg);
			}
			
			$html = $this->getOrderSummary();
			
			//get adddress
			$model		= &$this->getModel('checkout');
			$address = $model->checkShippingAddress();
			
			require_once (JPATH_SITE.DS.'components'.DS.'com_k2store'.DS.'helpers'.DS.'plugin.php');
			$plugins = K2StoreHelperPlugin::getPluginsWithEvent( 'onGetPaymentPlugins' );
			
			$view = $this->getView( 'billing', 'html' );
			$view->set( 'hidemenu', false);
			$view->assign( 'orderSummary', $html );			
			$view->assign( 'address', $address );			
			$view->assign( 'plugins', $plugins );
		
		JRequest::setVar('layout', 'default');
		
		parent::display();		
	}
	
function getOrderSummary()
	{

	    $params = &JComponentHelper::getParams('com_k2store');
		$model = $this->getModel('mycart');
		$view = $this->getView( 'mycart', 'html' );	
		$view->set( '_view', 'mycart' );
		$view->set( '_doTask', true);
		$view->set( 'hidemenu', true);
		$view->setModel( $model, true );
		$view->assign( 'items', $model->get('Data'));
		$view->assign( 'params', $params );
		$view->assign( 'summary', true );
		$view->setLayout( 'ajax' );

		ob_start();
		$view->display();
		$html = ob_get_contents();
		ob_end_clean();

		return $html;
	}
	

function save()
	{
		$mainframe = &JFactory::getApplication();
		JRequest::checkToken() or jexit('Invalid Token');
		
		$type = JRequest::getWord('savetype', 'order');
		$model = $this->getModel($type);
		$model->save(true);
		$link = JRoute::_('index.php?option=com_k2store&view=billing');
		$msg = JText::_('Shipping address saved sucessfully');
		$mainframe->redirect($link, $msg);		
	}
	
	function preparePayment() {
		
		global $mainframe;
		$user 		=	& JFactory::getUser();
		$values = JRequest::get('post');
		
		if(empty($values['payment_plugin'])) {
			
			$link = JRoute::_('index.php?option=com_k2store&view=billing');
			$msg = JText::_('Select a payment method');
			$mainframe->redirect($link, $msg);
		}
		
		//let us save the data in our hand with Pending status
		
		$billing = &$this->getModel('billing');
		
		//save and save function returns the order table id
		$order_payment_id = $billing->saveOrder($values['payment_plugin'], $user->id);
		
		if(!$order_payment_id) {
			$link = JRoute::_('index.php');
			$msg = JText::_('This action is not allowed');
			$mainframe->redirect($link, $msg);		
			
		}
		
		//get the saved order details 
		$order_details = $billing->getSavedOrder($order_payment_id);
		
		//assign the order details to the values array
		
		$values['order_id'] = $order_details->order_id;
		
		$values['orderpayment_id'] = $order_payment_id;
		$values['orderpayment_amount'] = round($order_details->orderpayment_amount, 2);
		
		$model	= &$this->getModel('checkout');
		$address = $model->checkShippingAddress();
		
		foreach ($address as $key=>$value) {
		
			$values['orderinfo'][$key] = $value;
		
		}
		
		$values['orderinfo']['user_email'] = $user->email;
		
		//let us set the order_id for use when user comes back for the postPayment "View Invoice" link
		$mainframe =& JFactory::getApplication();
		$mainframe->setUserState( 'k2store.order_id', $order_details->order_id);
		
		//once we finish here... let us unset the cart session. So that it prevents duplicate saving of records.
		$session = JFactory::getSession();
		$session->set('shopping_cart', null);
		
		//process the payment plugin
		
		$dispatcher    =& JDispatcher::getInstance();
		JPluginHelper::importPlugin ('k2store');
		$results = $dispatcher->trigger( "onPrePayment", array( $values['payment_plugin'], $values ) );
		
		// Display whatever comes back from Payment Plugin for the onPrePayment
		$html = "";
		for ($i=0; $i<count($results); $i++)
		{
			$html .= $results[$i];
		}

		echo $html;	
		
			
	}
	
	
	//get payment confirmation...
	
	/**
	 * This method occurs after payment is attempted,
	 * and fires the onPostPayment plugin event
	 *
	 * @return unknown_type
	 */
	function confirmPayment()
	{
	
		$orderpayment_type = JRequest::getVar('orderpayment_type');

		// Get post values
		$values = JRequest::get('post');

		// process the post payment
		$dispatcher =& JDispatcher::getInstance();
		JPluginHelper::importPlugin ('k2store');
		$results = $dispatcher->trigger( "onPostPayment", array( $orderpayment_type, $values ) );

		// Display whatever comes back from Payment Plugin for the onPostPayment
		$html = "";
		for ($i=0; $i<count($results); $i++)
		{
			$html .= $results[$i];
		}

		// get the order_id from the session set by the prePayment
		$mainframe =& JFactory::getApplication();
		$order_id = $mainframe->getUserState( 'k2store.order_id' );
		$order_link = 'index.php?option=com_k2store&view=orders&task=view&id='.$order_id;

	//	$progress = $this->getProgress();

		// Set display
		$view = $this->getView( 'billing', 'html' );
		$view->setLayout('postpayment');
		$view->set( '_doTask', true);
		$view->assign('order_link', $order_link );
		$view->assign('plugin_html', $html);
			
		// Get and Set Model
		$model = $this->getModel('billing');
		$view->setModel( $model, true );
		$view->display();

		return;
	}
}
?>