<?php
/******************************************************************************************
* $Id: view.html.php 79 2011-04-02 16:01:50Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access');
jimport("joomla.application.component.view");

class JvleViewRecommend extends JView
{
//***************************************************************************************************     
    function display($tpl = null)
    {
        $cfg = JvleCfg::getInstance();

        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);
        
        $error = 0;
        $dispmsg = '';
        try
        {
            $auth = 0;
            $user =& JFactory::getUser();
            if (($cfg->recweb_by == "all") || (($cfg->recweb_by == "registered") && ($user->get('id'))))
                $auth = 1;
            
            if (!$auth)
                throw new Exception(JText::_("COM_JVLE_A33"));
                
            $mode = JRequest::getInt('mode', 0);
            if ($mode)        
            {
                if (!JvleSiteUtil::processCaptcha())
                    throw new Exception(JText::_("COM_JVLE_A46"));
                
                $url = JRequest::getString("siteurl", "");
                $reason = JRequest::getString("reason", "");
                $name = JRequest::getString("name", "");
                $email = JRequest::getString("email", "");
                if (($url == "") || ($reason == "") || ($name == "") || ($email == ""))
                    throw new Exception(JText::_("COM_JVLE_A48"));     
                
                if ((JString::substr($url, 0, 7) != 'http://') && (JString::substr($url, 0, 8) != 'https://')) 
                    throw new Exception(JText::_("COM_JVLE_A47"));
                
                $em_msg = str_replace("{REASON}", htmlspecialchars($reason), str_replace("{URL}", htmlspecialchars($url), str_replace("{EMAIL}", htmlspecialchars($email), str_replace("{NAME}", htmlspecialchars($name), JText::_("COM_JVLE_A32")))));
                $em_msg .= "\n".$cfg->self_url;
                JvleUtil::sendEmail($cfg->self_email, JText::_("COM_JVLE_A31"), $em_msg);
                
                $dispmsg = JText::_("COM_JVLE_A30");
            }
        }
        catch (Exception $ex)
        {
            $error = 1;
            $dispmsg = $ex->getMessage();
            $nextpage = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=recommend");    
        }
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('tmpl', $tmpl); 
        $this->assignRef('dispmsg', $dispmsg);                       
        $this->assignRef('error', $error);
        $this->assignRef('npage', $nextpage);
        
        $tmpl->setMetaData(JText::_("COM_JVLE_A157"), JText::_("COM_JVLE_A158"));

        $document =& JFactory::getDocument();        
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);       
    }
//***************************************************************************************************                       
}