<?php
/******************************************************************************************
* $Id: jvle.php 106 2011-07-07 10:16:14Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport('joomla.application.component.model');
#*****************************************************************************************
class JvleModelJvle extends JModel 
{
    var $_pagination = null;
    var $_total = null;
    var $_data = null;

    function __construct()
    {
        parent::__construct();
        
        $cfg = JvleCfg::getInstance();
        $limit = $cfg->fe_num_links;
        $limitstart = JRequest::getInt('limitstart', 0);
            
        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);    
    }
    
    function getTotal()
    {
        if (empty($this->_total))
        {
            $cid = JRequest::getInt('cid', 0);
            $this->_total = JvleDb::getCount("select count(id) as CNT from `#__jvle_links` where link_status = 'ESTABLISHED' and link_category = '".(int)$cid."'");
        }

        return $this->_total;
    }

    function getData()
    {
        if (empty($this->_data))
        {
            $cid = JRequest::getInt('cid', 0);
            $this->_data = JvleDb::getRows("select * from `#__jvle_links` where link_status = 'ESTABLISHED' and link_category = '".(int)$cid."' order by link_published_on desc limit ".(int)$this->getState('limitstart').", ".(int)$this->getState('limit'));
        }

        return $this->_data;
    }

    function getPagination()
    {
        if (empty($this->_pagination))
        {
            jimport('joomla.html.pagination');            
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_pagination;
    }
    
    function rateLink()
    {
        $lid = JRequest::getInt('lid', -1);
        $rating = JRequest::getInt('rating', 0);        
        
        $u_ip = $_SERVER['REMOTE_ADDR'];
        $mrv = JvleDb::getRow("select * from #__jvle_votes where lid = '".(int)$lid."' and vote_ip = '".JvleSecure::defendSQL($u_ip)."'");
                
        $allow_vote = 0;
        if ($mrv)
        {
            if (time() < ((24*3600) + $mrv->vote_time))
                return 1;
            else
                $allow_vote = 1;
        }
        else
            $allow_vote = 2;

        if ($allow_vote)
        {                
            $mr = JvleDb::getRow("select num_votes, link_rating from #__jvle_links where id = '".(int)$lid."'");
            $nrating = (($mr->link_rating * $mr->num_votes) + $rating)/($mr->num_votes + 1);
            JvleDb::update("update #__jvle_links set num_votes = num_votes + 1, link_rating = ".(float)$nrating." where id = ".(int)$lid);
                    
            if ($allow_vote == 2)    
                JvleDb::update("insert into #__jvle_votes values('','".(int)$lid."','".JvleSecure::defendSQL($u_ip)."','".time()."')");
            else
                JvleDb::update("update #__jvle_votes set vote_time = '".time()."' where id = '".(int)$mrv->id."'");
                        
            return 0;
        }
    }
    
    function addWebsite($exchange_link, &$retmsg)
    {
        try
        {
            $session =& JFactory::getSession();
            $cfg = JvleCfg::getInstance();
            
            /* DG:5-S */            
            $partner_url = JRequest::getString('purl', ''); $session->set('purl', $partner_url, 'aform');
            $partner_email = JRequest::getString('pemail', '');  $session->set('pemail', $partner_email, 'aform');
            $reciprocal_link_url = JRequest::getString('prurl', '');  $session->set('prurl', $reciprocal_link_url, 'aform');            
            $link_category = JRequest::getInt('pcat', 0);  $session->set('pcat', $link_category, 'aform');            
            $partner_title = JRequest::getString('ptitle', '');  $session->set('ptitle', $partner_title, 'aform');
            $partner_desc = JRequest::getString('pdesc', '');  $session->set('pdesc', $partner_desc, 'aform');
            /* DG:5-F */
            
            /* CS:1-S */
            if (!JvleSiteUtil::processCaptcha())
                throw new Exception(JText::_("COM_JVLE_A46"));
            /* CS:1-F */
            
            if (($partner_url == '') || ($partner_email == ''))
                throw new Exception(JText::_("COM_JVLE_A48"));
                
            if (!preg_match('/^[_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)+$/', $partner_email))
                throw new Exception(JText::_("COM_JVLE_A99"));
                
            if (($exchange_link) && ($partner_title == ''))
                throw new Exception(JText::_("COM_JVLE_A95"));

            if (($exchange_link) && ($reciprocal_link_url == ''))
                throw new Exception(JText::_("COM_JVLE_A94"));                

            if (!$link_category)
                throw new Exception(JText::_("COM_JVLE_A96"));
                
            $partner_url = JvleUtil::stripLastChar($partner_url);
            if ($reciprocal_link_url != '')
                $reciprocal_link_url = JvleUtil::stripLastChar($reciprocal_link_url);

            if (!JvleUtil::isNewLink($partner_url))
                throw new Exception(JText::_("COM_JVLE_A97"));         
           
            $catobj = JvleDb::getRow("select maxlinks from #__jvle_categories where id = '".(int)$link_category."'");
            if (($catobj->maxlinks) && ((1 + JvleUtil::getNumlinks($link_category)) > $catobj->maxlinks))
                throw new Exception(JText::_("COM_JVLE_A98"));
           
            if (JvleSiteUtil::isUrlHacked($partner_url, $reciprocal_link_url))
                throw new Exception(JText::_("COM_JVLE_A100"));
                        
            if (JvleSiteUtil::isLoopback($reciprocal_link_url))
                throw new Exception(JText::_("COM_JVLE_A100"));
            
            if ($cfg->enable_rlc_fe)
            {
                $ret = JvleUtil::checkReciprocalLink($reciprocal_link_url, $cfg->self_url);
                if ($ret)
                    throw new Exception(JText::_("COM_JVLE_A102"));
                
                $rlc_last_doneon = time();
            }
            else
                $rlc_last_doneon = 0;

            $banner_file = '';  
            if (!$exchange_link)
            {                
               $ret = JvleUtil::uploadFile('pbanner', _MOS_ABS_BANNERS, $banner_file, $cfg->banner_extns, $cfg->banner_kbsize_max, $cfg->banner_width_max, $cfg->banner_height_max);                   
               switch ($ret)
               {
                   case 1: throw new Exception(JText::_("COM_JVLE_A103")); break;
                   case 2: throw new Exception(JText::_("COM_JVLE_A104").': '._MOS_ABS_BANNERS); break;
                   case 3: throw new Exception(JText::_("COM_JVLE_A105")); break;
                   case 4: throw new Exception(JText::_("COM_JVLE_A106")); break;
                   case 5: throw new Exception(JText::_("COM_JVLE_A107").': '.$cfg->banner_kbsize_max.' KB'); break;
                   default: break;
                }              
            }
            
            if ($cfg->auto_approve)
            {
                $link_status = 'ESTABLISHED';
                $pubon = time();
            }
            else
            {
                $link_status = 'PENDING';
                $pubon = 0;                
            }
            
            $emstr = JvleSiteUtil::generateKey(32);
            
            $sql = "insert into #__jvle_links values(NULL,'TWO-WAY','".JvleSecure::defendSQL($partner_title)."','".JvleSecure::defendSQL($partner_url)."','".JvleSecure::defendSQL($partner_desc)."','".JvleSecure::defendSQL($partner_email)."','".JvleSecure::defendSQL($reciprocal_link_url)."','".(int)$link_category."','".$link_status."','".time()."','".$pubon."','0','0','".$rlc_last_doneon."','','".JvleSecure::defendSQL($emstr)."','0','1','1','0','".(int)$exchange_link."','".JvleSecure::defendSQL($banner_file)."','0')";
            if (!JvleDb::update($sql))
                throw new Exception('Database error encountered');
            
            $ploc = _MOS_LIVESITE."index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=all_category_links&cid=".$link_category;
            if ($link_status == 'ESTABLISHED')
            {
                $em_msg = str_replace("{P-LOC}", $ploc, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A108"))));
                JvleUtil::sendEmail($partner_email, JText::_("COM_JVLE_A112"), $em_msg);
                
                $result_msg = ($cfg->enable_rlc_fe) ? JText::_("COM_JVLE_A110") : JText::_("COM_JVLE_A111");
                $em_msg = str_replace("{P-LOC}", $ploc, str_replace("{RECIP-RESULT-MSG}", $result_msg, str_replace("{P-RURL}", $reciprocal_link_url, str_replace("{CATNAME}", JvleUtil::getCategoryName($link_category), str_replace("{P-EMAIL}", $partner_email, str_replace("{P-URL}", $partner_url, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A109"))))))));
                JvleUtil::sendEmail($cfg->self_email, JText::_("COM_JVLE_A113"), $em_msg);
            }
            else
            {
                $approve_msg = $reject_msg = '';
                if ($cfg->email_approval)
                {
                    $approval_url = _MOS_LIVESITE."index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=emappr&emstr=".$emstr."&act=1";
                    $approve_msg = str_replace("{APPROVAL-URL}", $approval_url, JText::_("COM_JVLE_A116"));   
                    
                    $reject_url = _MOS_LIVESITE."index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=emappr&emstr=".$emstr."&act=0";
                    $reject_msg = str_replace("{REJECT-URL}", $reject_url, JText::_("COM_JVLE_A117"));   
                }
                
                $result_msg = ($cfg->enable_rlc_fe) ? JText::_("COM_JVLE_A110") : JText::_("COM_JVLE_A111");
                $em_msg = str_replace("{EMAIL-APPR-MSG}", $approve_msg, str_replace("{EMAIL-REJT-MSG}", $reject_msg, str_replace("{P-LOC}", $ploc, str_replace("{RECIP-RESULT-MSG}", $result_msg, str_replace("{P-RURL}", $reciprocal_link_url, str_replace("{CATNAME}", JvleUtil::getCategoryName($link_category), str_replace("{P-EMAIL}", $partner_email, str_replace("{P-URL}", $partner_url, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A114"))))))))));
                JvleUtil::sendEmail($cfg->self_email, JText::_("COM_JVLE_A115"), $em_msg);
            }
            
            /* DG:5-S */
            $session->clear('purl', 'aform');
            $session->clear('pemail', 'aform');
            $session->clear('prurl', 'aform');
            $session->clear('pcat', 'aform');
            $session->clear('ptitle', 'aform');
            $session->clear('pdesc', 'aform');
            /* DG:5-F */
            
            $retmsg = JText::_("COM_JVLE_A118");
            return 1;
        }
        catch (Exception $ex)
        {
            $retmsg = $ex->getMessage();
            return 0;   
        }
    }
    
    function runCronJob()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_scheduler)   
            return;

        $DELAY_TIME = 60000;
        $start_time = date("M j Y H:i:s", time());
        
        $out_url = $out_email = $out_cstatus = $out_nstatus = $out_msg = array();
        $links = JvleDb::getRows("select * from #__jvle_links where link_type = 'TWO-WAY' and enable_scheduler = '1' and reciprocal_link_url != ''");
        if (!count($links))
            return;
        
        foreach ($links as $link)
        {
            array_push($out_url, $link->partner_url);
            array_push($out_email, $link->partner_email);
            array_push($out_cstatus, $link->link_status);
            
            $ret = JvleUtil::checkReciprocalLink($link->reciprocal_link_url, $cfg->self_url);
            switch ($ret)
            {
                case 0: {
                    $msg = 'Reciprocal link is available and intact in your partner site';
                    $new_status = 'ESTABLISHED';
                    break;
                }
                case 1: {
                    $msg = 'Read Error';
                    $new_status = $link->link_status;
                    break;
                }
                case 2: {
                    $msg = 'Reciprocal link to your website contains rel=nofollow';
                    $new_status = 'PENDING';
                    break;
                }
                case 3: {
                    $msg = 'Reciprocal link to your website does not exist';
                    $new_status = 'PENDING';
                    break;
                }
                default: {
                    $msg = 'Unknown Response. Please investigate manually on the reciprocal link';
                    $new_status = $link->link_status;
                    break;
                }
            }

            array_push($out_msg, $msg);
            
            if ($cfg->rlc_status_update) 
            {
                JvleUtil::changeLinkStatus($link->id, $new_status);
                array_push($out_nstatus, $new_status);
            } 
            else
            {
                array_push($out_nstatus, $link->link_status);                
            }
            
            JvleUtil::updateLastRecipDate($link->id); /* DG:6 */
            usleep($DELAY_TIME);
        }

        $end_time = date("M j Y H:i:s", time());
        
        if (!count($out_url))
            return;

        $html_msg = "<html><head></head><body>";
        $html_msg .= "<center>***************************************************************************************<br />";
        $html_msg .= "<strong>JV-LinkExchanger</strong>: Results of CRON Job for Reciprocal link checks for all two way links which have the scheduled check parameter enabled, are as follows. <br />Reciprocal link checks Start time ".$start_time."<br />";
        $html_msg .= "<table width='100%' cellpadding='3' cellspacing='3' border='1'>";
        $html_msg .= "<tr>";
        $html_msg .= "  <th width='5%' align='center'>Sno</th>";
        $html_msg .= "  <th width='20%' align='center'>Partner URL</th>";
        $html_msg .= "  <th width='35%' align='center'>Check Result</th>";
        $html_msg .= "  <th width='15%' align='center'>Partner Email</th>";
        $html_msg .= "  <th width='10%' align='center'>Link Status Before Check</th>";
        $html_msg .= "  <th width='10%' align='center'>Link Status After Check</th>";
        $html_msg .= "</tr>";
        for ($j=1,$i=0;$i<count($out_url);$i++,$j++)
        {
            $html_msg .= "<tr>";
            $html_msg .= "  <td align='center'>".$j."</td>";
            $html_msg .= "  <td align='center'>".$out_url[$i]."</td>";
            $html_msg .= "  <td align='center'>".$out_msg[$i]."</td>";
            $html_msg .= "  <td align='center'>".$out_email[$i]."</td>";
            $html_msg .= "  <td align='center'>".$out_cstatus[$i]."</td>";
            $html_msg .= "  <td align='center'>".$out_nstatus[$i]."</td>";        
            $html_msg .= "</tr>";
        }    
        $html_msg .= "</table>";
        $html_msg .= "<br />***************************************************************************************<br />";
        $html_msg .= "Reciprocal link checks Finish time ".$end_time."</center></body></html>";

        if ($cfg->result_mode == "email") 
            JvleUtil::sendEmail($cfg->self_email, "JV-LinkExchanger: Cron Job - Scheduled Automatic Reciprocal Links Check Results", $html_msg, 1);
        else
        {
            $cdate = date("Y-m-d-H-i", time());
            $filename = _MOS_ABSPATH.DS.'temp'.DS.'SRC_'.$cdate.'.html';
            $fp = fopen($filename, "w");
            if (!$fp)
                JvleUtil::sendEmail($cfg->self_email, "JV-LinkExchanger: Cron Job - Scheduled Automatic Reciprocal Links Check Results", $html_msg, 1);    
            else
            {
                fwrite($fp, $html_msg);
                fclose($fp);
                JvleUtil::sendEmail($cfg->self_email, "JV-LinkExchanger: Cron Job - Scheduled Automatic Reciprocal Links Check Results", "Scheduled automatic reciprocal links check process is completed. The results have been consolidated into a file and stored in ".$filename.". You may FTP this file and view the results");    
            }    
        }
    }
}