<?php
/******************************************************************************************
* $Id: jvle.utilities.php 110 2011-07-07 11:12:39Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 

class JvleSiteUtil 
{
    function loadWebsnap($cid, $lnk_snap_status)
    {
        $cfg = JvleCfg::getInstance();

        if (!$cfg->enable_snap) return '';
        
        $catsnapstatus = JvleDb::getValue("select snap_status from #__jvle_categories where id = '".(int)$cid."'");
        if (!$catsnapstatus) return '';
        
        return (!$lnk_snap_status) ? '' : ' class="snap_shots"';
    }
    
    function showCaptchaForm($msg)
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_captcha)
            return '';
        
        $n1 = rand(1, 99);
        $n2 = rand(1, 99);
        $sum = $n1 + $n2;
                
        return '<tr>
                    <td height="25" width="30%" valign="top" style="text-align: right">'.$msg.' '.$n1.' + '.$n2.' = </td>
                    <td height="25" width="70%" valign="top"><input type="text" name="icode" id="icode" value="" /><input type="hidden" name="hcode" value="'.md5($sum).'" /></td>    
                </tr>';
    }
    
    function processCaptcha()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_captcha)
            return 1;        
            
        $hcode = JRequest::getString('hcode', 'na');
        $icode = JRequest::getInt('icode', 0);
        
        if (md5($icode) == $hcode)
            return 1;
        
        return 0;
    }
    
    function isUrlHacked($purl, $rurl)
    {
        $match = JString::substr($rurl, 0, JString::strlen($purl));
        return ($match == $purl) ? 0 : 1;
    }
    
    function isLoopback($rurl)
    {
        $match = JString::substr($rurl."/", 0, JString::strlen(_MOS_LIVESITE));
        return ($match == _MOS_LIVESITE) ? 1 : 0;
    }

    function generateKey($plength)
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        mt_srand(microtime() * 1000000);
        for($pwd='',$i= 0;$i<$plength;$i++)
        {
            $key = mt_rand(0,JString::strlen($chars)-1);
            $pwd = $pwd . $chars{$key};
        }    
        for($i = 0; $i < $plength; $i++)
        {
            $key1 = mt_rand(0,JString::strlen($pwd)-1);
            $key2 = mt_rand(0,JString::strlen($pwd)-1);
    
            $tmp = $pwd{$key1};
            $pwd{$key1} = $pwd{$key2};
            $pwd{$key2} = $tmp;
        }    
        $pwd = htmlentities($pwd, ENT_QUOTES);    
        return $pwd;
    } 
}