<?php
/**
 * Admin interface
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 Roland Dalmulder
 * @version 	$Id: csvivirtuemart.php 1589 2011-05-03 10:00:21Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

// Make sure we are coming in via index2.php, if not redirect to it
$mainframe = JFactory::getApplication();
$uri = JURI::getInstance();
$format = $uri->getVar('format', false);
if ($uri->_path == '/index.php' || !$format) {
	$uri->_path = str_replace('/index.php', '/index2.php', $uri->_path);
	$uri->setVar('format', 'raw');
	$mainframe->redirect($uri->toString());
}

// Define the tmp folder
$config = JFactory::getConfig();
$tmp_path = $config->getValue('config.tmp_path');
if (!defined('CSVIPATH_TMP')) define('CSVIPATH_TMP', JPath::clean($tmp_path.'/com_csvivirtuemart', '/'));
if (!defined('CSVIPATH_DEBUG')) define('CSVIPATH_DEBUG', JPath::clean($tmp_path.'/com_csvivirtuemart/debug', '/'));

// Set the global settings
require_once(JPATH_COMPONENT_ADMINISTRATOR.'/models/settings.php');
$settings = new CsvivirtuemartModelSettings();
JRequest::setVar('settings', $settings);

// Load the logger
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/log.php');

// Load the general helper
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/csvi.php');

// Require the base controller
require_once (JPATH_COMPONENT.DS.'controller.php');

// Require specific controller if requested
if($controller = JRequest::getWord('controller', 'export')) {
   require_once (JPATH_COMPONENT.'/controllers/'.$controller.'.php');
}

// Create the controller
$classname   = 'CsvivirtuemartController'.$controller;
$controller = new $classname();

// Perform the Request task
$controller->execute(JRequest::getWord('view'));

// Redirect if set by the controller
$controller->redirect();
?>