<?php
// *************************************************************************
// *                                                                       *
// * Product: VirtueMart RBS WorldPay Business Gateway                     *
// * Filename: worldpayadv.form.php                                        *
// * Release Date: 2011.04.18                                              *
// * Build Time: 18 April 2011 21:37                                       *
// * Code Word: Srednekolymsk                                              *
// * Version: 1.5.34                                                       *
// * For: Joomla 1.5/VirtueMart 1.1.x                                      *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Author: E-commerce Solution                                           *
// * Email: support@virtuemart-solutions.com                               *
// * Website: http://www.virtuemart-solutions.com                          *
// * Copyright: (C) 2008-2010 All rights reserved.                         *
// * Licence: Commercial                                                   *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.  This software  or any other *
// * copies thereof may not be provided or otherwise made available to any *
// * other person.  No title to and  ownership of the  software is  hereby *
// * transferred.                                                          *
// *                                                                       *
// * You may not reverse  engineer, decompile, defeat  license  encryption *
// * mechanisms, or  disassemble this software product or software product *
// * license.  Ecom Solution  may  terminate  this license  if you fail to *
// * comply with any of the terms and conditions set forth in our end user *
// * license agreement (EULA).  In such event,  licensee  agrees to return *
// * licensor  or destroy  all copies of software  upon termination of the *
// * license.                                                              *
// *                                                                       *
// *************************************************************************


function worldpay_md5form($db, $user, $oid) { 
  global $mosConfig_site_name;  
  global $page;  
  
  //$currency = $_SESSION['vendor_currency'];
  $currency = $db->f("order_currency");
  $total = sprintf("%01.2f", $db->f("order_total"));  

  $worldpay_sigflds ="instId:amount:currency:cartId" ;
  $worldpay_md5 = worldpay_md5value($total,  $currency, $oid, $worldpay_sigflds );
  
  // define the url
  if (WPADV_TEST == 0) $gateway_url = 'https://secure.wp3.rbsworldpay.com/wcc/purchase';
  else $gateway_url = 'https://secure-test.wp3.rbsworldpay.com/wcc/purchase';	

?>
 

<!-- WorldPay MD5 Payment Form -->
<form name="frmWorldPay" 
  target="<?php echo WPADV_TARGET; ?>" 
  action="<?php echo $gateway_url; ?>" method="post"> 
  
	<input type="hidden" name="testMode" value="<?php echo WPADV_TEST; ?>">
	<input type="hidden" name="authMode" value="<?php echo WPADV_AUTHMODE; ?>" />
	<input type="hidden" name="instId" value="<?php echo WPADV_INST_ID; ?>" />  
	                            
  <?php if (WPADV_ACC_ID != '') { ?>
    <input type="hidden" name="accId1" value="<?php echo WPADV_ACC_ID; ?>" />   
  <?php } ?>
  
	<input type="hidden" name="cartId" value="<?php echo $oid; ?>" />
	<input type="hidden" name="amount" value="<?php echo $total; ?>" />
	<input type="hidden" name="currency" value="<?php echo $currency; ?>" />
	<input type="hidden" name="desc" value="<?php echo(WPADV_DESC . $oid); ?>" />
	
	<input type="hidden" name="email" value="<?php echo $user->user_email; ?>" />
	<input type="hidden" name="address" 
	  value="<?php  
	  
    echo remove_slashes($user->address_1) . ",\r\n";
    if(trim($user->address_2) != '')   
      echo remove_slashes($user->address_2) . ",\r\n";  
    echo remove_slashes($user->city) . "\r\n";
    
    ?>"  
  />
	<input type="hidden" name="name" 
	  value="<?php echo $user->title?><?php echo $user->first_name. ' ' .$user->last_name; ?>" />
	<input type="hidden" name="country" value="<?php echo country_code_3_2($user->country); ?>"/>
	<input type="hidden" name="postcode" value="<?php echo $user->zip; ?>" />
	<input type="hidden" name="tel" value="<?php echo $user->phone_1; ?>" />
	
	<input type="hidden" name="withDelivery"  value="true" />
	
	<input type="hidden" name="signature" value="<?php echo $worldpay_md5; ?>" />
<?php if ($worldpay_md5 != '') { ?>
	<input type="hidden" name="signatureFields" value="<?php echo $worldpay_sigflds; ?>" />
<?php } ?>

<p align="left">

<?php 
if ((WPADV_AUTO == '1') && ($page == 'checkout.thankyou')) 
  echo WPADV_BTN_TEXT_AUTO;
else  
  echo WPADV_BTN_TEXT;
  
?>

<input type="submit" name="Continue" value="Continue"> 
<p>

</form>
<!-- end Payment Form -->

<?php if ((WPADV_AUTO == '1') && ($page == 'checkout.thankyou')) { ?>

<script language="JavaScript">
  setTimeout("document.forms['frmWorldPay'].submit();",1000);
</script> 
  
<?php } else { ?>

	<?php if (WPADV_SHOWCARDS == '1') { ?>

	<script language=JavaScript 
	src="https://secure.wp3.rbsworldpay.com/wcc/logo?instId=<?php echo WPADV_INST_ID; ?>">
	</script> 	
	<?php } ?>
	
<?php } ?>  


<?php
}

  //error_reporting(0);
  
  // get order user info if not in checkout
  if ($page != 'checkout.thankyou') {
	$q = "SELECT * FROM #__{vm}_orders WHERE order_id='$order_id'";
	$db->query($q);
	
	if( $db->next_record() ) {	
		  $user_id = $db->f("user_id");
		  $dbt = new ps_DB;
		  $qt = "SELECT * from #__{vm}_order_user_info WHERE user_id='$user_id' AND order_id='$order_id' ORDER BY address_type ASC"; 
		  $dbt->query($qt);
		  $dbt->next_record();
		  $user = $dbt->record[0];		  
	}		  
  }	  		  

  /*** Get the Configuration File ***/
  require_once(CLASSPATH ."payment/ps_worldpayadv.cfg.php");  

  // include generic_fns
  require_once($mosConfig_absolute_path . '/administrator/components/com_worldpayadv/generic_fns.php');

  // SHOW THE FORM ;)
  worldpay_md5form($db, $user, $order_id);


function worldpay_md5value($total, $currency, $oid,  $sigflds ) {
     // Worldpay MD5 capability 
     // updated 14/04/2001
     // http://www.rbsworldpay.com/support/bg/index.php?page=news&sub=md5&c=UK
  
     $worldpay_signature = '';
     //$sigstr = WPADV_MD5 . ':' . WPADV_INST_ID . ':' . sprintf("%01.2f", $total) . ':' . $currency . ':' . $oid;
     $sigstr = WPADV_MD5 . ';' . $sigflds . ';' . WPADV_INST_ID . ';' . sprintf("%01.2f", $total) . ';' . $currency . ';' . $oid;

     if (WPADV_MD5 != "") $worldpay_signature = md5($sigstr);
     return $worldpay_signature;
}	 
	
function remove_slashes ($str) {
  $s = str_replace("\'", "'", $str);
    return $s;
}


?>