<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport( 'joomla.application.component.view' );

class ViewQuotes extends JView {
    
    public function display($tpl = null) {
        
        $model      =   $this->getModel();
        $layout     =   $this->getLayout();
        
        switch ( $layout ) {
        	
        	case "form":
	        
	            // Get task
	            $task       =   JRequest::getVar("task","add",null,"string");
	            
	            if ( strcmp("edit",$task) == 0 ) { // Editing quote
	            	
	                $cid    =   JRequest::getVar( 'cid', array(),null, 'array' );
	                JArrayHelper::toInteger($cid);
	                
	                // Get item data
	                if ( !empty( $cid[0] ) ) {
	                    
	                    JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');
	                    $row = JTable::getInstance('Quotes', 'Table');
	                    
	                    $row->id = (int)$cid[0];
	                    
	                    if (!$row->load())  {
	                        
	                        $log    =   JLog::getInstance();
                            $log->addEntry(array("status"=>"Error", "comment"=> " Error : System can't load quote data." ));
                            JError::raiseError(500, JText::_("System error!"));
	                         
	                    }
	                    
	                } else {
	                    
	                    JError::raiseError(500, JText::_( 'Select quote, please!', true ) );
	                }
	                
	                $this->assignRef('item', $row);
	            } else {
	            	$this->assign('author', JFactory::getUser()->get('name') );
	            }
		        
	            // Load a JEditor object
                $editor = JFactory::getEditor();
                $this->assignRef('editor',  $editor);
                
	            $app = JFactory::getApplication();
	            $app->setUserState("redirect.view", $this->getName());
            
            break;
            
            // Quote listing
        	default:
            
                global $mainframe, $option;
        
                $jsCategories = "onchange=\"if (this.options[selectedIndex].value!=''){ document.adminForm.submit(); }\"";
                
                // prepare list array
                $lists = array();
                
                $filter_order       = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order",        'filter_order',     'quote', 'cmd' );
                $filter_order_Dir   = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order_Dir",    'filter_order_Dir', '','word' );
                    
    			// get the user-state of the published filter
	            $filter_state = $mainframe->getUserStateFromRequest("$option." . $this->getName() . ".filter_state",	'filter_state');
                // set the table filter values
				$lists['state'] = JHTML::_('grid.state', $filter_state);

                // table ordering
                $lists['order_Dir'] = $filter_order_Dir;
                $lists['order']     = $filter_order;
                
                // Filter Search
	            $filter_search   = $mainframe->getUserStateFromRequest($option.'.quotes.filter_search','filter_search');
	            $lists['search'] = $filter_search;
	            
	            /**** Filter Categories ****/
	            $filter_catid = $mainframe->getUserStateFromRequest($option.'.quotes.filter_catid','filter_catid');
                settype($filter_groupid,"integer");
            
                $modelCategories = JModel::getInstance('Categories',"Model");
	            // add first 'select' option
	            $options_categories = array();
	            $options_categories[] = JHTML::_('select.option', '0', JText::_('Choose category'),"id","name");

	            $categories = $modelCategories->getData();
	            
	            // append database results
	            $options_categories = array_merge($options_categories, $categories);
                
	            // build form control
	            $lists['catid'] = JHTML::_('select.genericlist', $options_categories, 'filter_catid', 'class="inputbox" size="1" '.$jsCategories,'id', 'name', $filter_catid);
	            
	            /**** Filter Authors ****/
                $filter_author = $mainframe->getUserStateFromRequest($option.'.quotes.filter_author','filter_author');
            
                // add first 'select' option
                $options_authors = array();
                $options_authors[] = JHTML::_('select.option', '0', JText::_('Choose author'),"id","name");

                $authors  = array();
                $authors_ = $model->getAuthors();
                foreach ( $authors_ as &$author ) {
                	$authors[] =   array( 'id'=>$author, 'name'=>$author);
                }
                
                // append database results
                $options_authors = array_merge($options_authors, $authors);
                
                // build form control
                $lists['author'] = JHTML::_('select.genericlist', $options_authors, 'filter_author', 'class="inputbox" size="1" '.$jsCategories,'id', 'name', $filter_author);
	
                $pagination = & $this->get( 'Pagination' );
                
                $this->assignRef('lists',       $lists);
                $this->assignRef('pagination',  $pagination);
                $this->assignRef('items',       $model->getData());
            break;
        }
        
        $modelCategories  =   JModel::getInstance("Categories","Model");
        $this->assignRef("categories",$modelCategories->getCategories());
        
        parent::display($tpl);
    }
    
    
}
?>