<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport('joomla.application.component.view');

class ViewCategories extends JView {
    
    public function display($tpl = null) {
        
        $model      =   $this->getModel();
        $layout     =   $this->getLayout();
        
        switch ( $layout ) {
        	
        	case "form":
                
                // Get task
                $task       =   JRequest::getVar("task","add",null,"string");
                
                if ( strcmp("edit",$task) == 0 ) { // Edit
                    
                    $cid    =   JRequest::getVar( 'cid', array(), null, 'array' );
                    JArrayHelper::toInteger($cid);
                    
                    // Get item data
                    if ( !empty( $cid[0] ) ) {
                        
                        JTable::addIncludePath(JPATH_COMPONENT.DS.'tables');
                        $row =& JTable::getInstance('Categories', 'Table');
                        
                        $row->id = (int)$cid[0];
                        
                        if (!$row->load())  {
                            
                            $log    =   JLog::getInstance();
				            $log->addEntry(array("status"=>"Error", "comment"=> " Error : Can't load category data." ));
				            JError::raiseError(500, JText::_("System error!"));
                             
                        }
                        
                    } else {
                        
                        JError::raiseError(500, JText::_( 'Select category, please!', true ) );
                    }
                    
                    $this->assignRef('item', $row);
                    
                }
                
                $app = JFactory::getApplication();
                $app->setUserState("redirect.view", $this->getName());
        
            break;
            
        	default:
             
        		global $mainframe, $option;
            
                $filter_order       = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order",       'filter_order',     'name', 'cmd' );
                $filter_order_Dir   = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order_Dir",   'filter_order_Dir', '',         'word' );
                    
                // table ordering
                $lists['order_Dir'] = $filter_order_Dir;
                $lists['order']     = $filter_order;
                
                $pagination = & $this->get( 'Pagination' );
                
                $this->assignRef('lists',       $lists);
                $this->assignRef('pagination',  $pagination);
                $this->assignRef('items',       $model->getData());
                
            
            break;
            
        }
        
        parent::display($tpl);
    }
    
    
}
?>