<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport( 'joomla.application.component.model' );

class ModelQuotes extends JModel {
    
    /**
	 * Category ata array
	 *
	 * @var array
	 */
	private $data = null;

	/**
	 * Category total
	 *
	 * @var integer
	 */
	private $total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	private $pagination = null;
	
    public function  __construct() {
        
        parent::__construct();
        
        global $mainframe, $option;

		// Set site limit settings
        if ( !$mainframe->isAdmin() ) {
            // At some point in the future this will come from a request object
            $limitstart = JRequest::getVar('limitstart', 0, '', 'int');
            $limit      = $mainframe->getCfg("list_limit");
        } else {
        	
        	// Get the pagination request variables
	        $limit      = $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
	        $limitstart = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . '.limitstart', 'limitstart', 0, 'int' );
        	
        }
        
		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		// Set redirection view
		$app = JFactory::getApplication();
        $app->setUserState("redirect.view", $this->getName());
        $app->setUserState("redirect.layout", "");
    }
    
    
    /**
	 * Method to get data
	 *
	 * @since 1.5
	 */
	public function getData( )	{

	    $query         =   $this->buildQuery();
	    
	    $this->data    =   $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
    
		return $this->data;
	}
	
	/**
	 * Method to get a pagination object of the items
	 *
	 * @access public
	 * @return integer
	 */
	public function getPagination()	{
	    
		// Lets load the content if it doesn't already exist
		if (empty($this->pagination))
		{
			jimport('joomla.html.pagination');
			$this->pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->pagination;
	}
    
	/**
	 * Method to get the total number of items
	 *
	 * @access public
	 * @return integer
	 */
	public function getTotal()	{
		// Lets load the content if it doesn't already exist
		if (empty($this->total))
		{
			$query = $this->buildQuery();
			
			$this->total = $this->_getListCount($query);
		}

		return $this->total;
	}
	
	/**
	 * Building query
	 *
	 * @return string
	 */
	public function buildQuery()	{
	    
		// Get the WHERE and ORDER BY clauses for the query
		$where		= $this->buildContentWhere();
		$orderby	= $this->buildContentOrderBy();

		$query  =   "SELECT  *
                        FROM " . $this->_db->nameQuote("#__vq_quotes");
        $query  .= $where;
        $query  .= $orderby;

		return $query;
	}

    /**
     * Build 'order'
     *
     * @return string
     */ 		
    private function buildContentOrderBy()	{
        
		global $mainframe, $option;
        $orderby    =   "";
        
        // Set site order settings
        if ( !$mainframe->isAdmin() ) {
        	
        	$order_types = array('date asc','date desc','author desc');
        	
            // Send mail to administrator
            $app    =   JFactory::getApplication();
            $params =   $app->getParams('com_vipquotes');
            $order_type_index = $params->get('orderBy');
            
            $order_type       = ( !isset( $order_types[$order_type_index] ) ) ? $order_types[0] : $order_types[$order_type_index];
            $orderby          = ' ORDER BY ' . $order_type;
            
        } else {
			// Order
	        $filter_order		= $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order",		'filter_order',		'name',	'cmd' );
	        $filter_order_Dir	= $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order_Dir",	'filter_order_Dir',	'',			'word' );
	
	        if ( $filter_order AND $filter_order_Dir ) {
			  $orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir;
	        }
        }

		return $orderby;
	}
	
	/**
     * Build 'where' 
     *
     * @return string
     */ 
	private function buildContentWhere()	{
	
		global $mainframe, $option;
		
		$where = array();
		
		if ( !$mainframe->isAdmin() ) {
			
			$filter_category = JRequest::getVar("category_id",null,'GET');
			
			// Set filter to public items
            $filter_state   =   "P";
            $filter_q       =   JRequest::getVar('q','');
            $filter_author  =   JRequest::getVar('search_by','author');
            
		    if ( !empty( $filter_category ) ) {
		    	$where[2] = ' category_id = ' . (int)$filter_category;
		    }
		    
            if ( !empty( $filter_q ) ) {
            	
            	// Search by author
            	if ( strcmp( "author",$filter_author ) == 0 ) {
            		$where[1] = ' author LIKE ("%' . addcslashes(addslashes( $filter_q ),"%_")  . '%")';
           		// Search in quotes
            	} else {
                    $where[1] = ' quote LIKE ("%' . addcslashes(addslashes( $filter_q ),"%_")  . '%")';
            	}
            }
            
                        
		} else {
			// get the user-state of the published filter
	        $filter_state  = $mainframe->getUserStateFromRequest($option . "." . $this->getName() . ".filter_state",    'filter_state');
	        $filter_search = $mainframe->getUserStateFromRequest($option . "." . $this->getName() . ".filter_search",   'filter_search');
	        $filter_catid  = $mainframe->getUserStateFromRequest($option . "." . $this->getName() . ".filter_catid",    'filter_catid');
	        $filter_author = $mainframe->getUserStateFromRequest($option . "." . $this->getName() . ".filter_author",   'filter_author');
//	        exit(var_dump($filter_search));
	        if ( !empty( $filter_search ) ) {
	           $where[] = ' quote LIKE ("%' . addcslashes(addslashes( $filter_search ),"%_")  . '%")';
	        }
	        
		    if ( !empty( $filter_catid ) ) {
               $where[] = ' category_id = ' . (int)$filter_catid;
            }
            
		    if ( !empty( $filter_author ) ) {
               $where[] = ' author = ' . $this->_db->Quote($filter_author);
            }
		}
        
		// Filters
	    // Determine published state
		if ($filter_state == 'P') {
		  $where[0] = ' published = 1';
		} elseif ($filter_state == 'U')	{
		  $where[0] = ' published = 0';
		} 
		
		$where = ( count( $where ) ) ? ' WHERE '. implode( ' AND ', $where ) : '' ;

		return $where;
	}
	
    
	/**
	 * Store item
	 *
	 */
    public function store( ) {
        
    	global $mainframe;
    	
    	// quote id
        $id         =   JRequest::getInt( 'id' );
        $quote      =   JRequest::getString( 'quote', "", "POST", JREQUEST_ALLOWHTML );
        $categoryId =   JRequest::getInt( 'category_id', 0 );
        
        // Set next destination
        VqHelper::setNextPage( $this->getName(), "form" );
        
        if ( empty( $quote ) ) {
        	JError::raiseWarning("500", JText::_( "Enter valid quote, please." ) );
        }
        
        if ( !$categoryId ) {
            JError::raiseWarning("500", JText::_( "Choose valid category, please." ) );
        }

        $row        =   $this->getTable();

        $row->set("id",         $id);
        
        /* Buackup quote */
        /* Todo: Use triggers */
        if ( $id ) {
	        
	        if ( !$mainframe->isAdmin() ) {
	            $row->set("user_id",    JFactory::getUser()->get("id"));
	        }
	        
	        $row->load();
	        
	        // Check for existing quote
	        if ( is_null( $row->date ) ) {
	        	JError::raiseError("500", JText::_( "System error!" ) );
	        }
	        
	        // Make history record
	        $this->backup($row);
	        
        }
        /* End Buackup quote */
        
        $row->set("quote",      $quote);
        $row->set("author",     JRequest::getString( 'author', "" ));
        $row->set("category_id",$categoryId);
        $row->set("published",  JRequest::getInt( 'published',0 ));
        
        // System don't set user id if I update quote
        if ( !$id ) {
	        $row->set("user_id",    JFactory::getUser()->get("id"));
	        
        	// Get parameters
	        $params     =   JComponentHelper::getParams('com_vipquotes');
	        $checkQuotes= $params->get('checkQuotes');
	        
	        // Check for existing quotes
	        if ( !empty( $checkQuotes ) ) {
	        	
				// prepare search
				$escaped = $this->_db->getEscaped($quote, true);

	            $query = "
	               SELECT 
	                   COUNT(*)
	               FROM
	                   `#__vq_quotes`
	               WHERE
	                   `quote` SOUNDS LIKE " . $this->_db->Quote('%' . $escaped . '%', false);
	            
	            $num = $this->_db->getOne( $query );
	            
	            if ( $num > 0 ) {
	                JError::raiseWarning("404", JText::_( "This quote exist in our database." ) );
	            }
	        }
        }
		
		$row->store();
		
		JFactory::getApplication()->enqueueMessage(JText::_("Quote saved successfully."));
        
    }
    
    /**
     * Delete items
     *
     * @param array $cids
     */
    public function delete( $cids ) {
        
    	global $mainframe;
        	
    	$userId   =   JFactory::getUser()->get("id");
    	
		// Delete items 
		$query = '
		  DELETE  
	      FROM 
	           `#__vq_quotes` 
		  WHERE   
		      `id` IN ( '.implode( ',', $cids ).' )';
		
		if ( !$mainframe->isAdmin() ) {
          
		  $query .= '
            AND    
              `user_id`=' . (int)$userId;
		}
		
		$this->_db->setQuery( $query );
		
		if(!$this->_db->query()) {
			$log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $this->_db->getErrorMsg()));
            JError::raiseError(500, JText::_("System error! Contact our administrators."));
		}
			
		JFactory::getApplication()->enqueueMessage(JText::_("Quote deleted."));
        
    }
    
    /**
     * Method to (un)publish item
     *
     * @access  public
     * @return  boolean True on success
     * @since   1.5
     */
	public function publish($cids = array(), $publish = 1) {
	    
		$query = '
		  UPDATE 
		      `#__vq_quotes` 
		         
	      SET     
	          `published` = '.(int) $publish . ' 
          WHERE   
              `id` IN ( '.implode( ',', $cids ).' )';

		$this->_db->setQuery( $query );
		
		if(!$this->_db->query()) {
               $log    =   JLog::getInstance();
               $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $this->_db->getErrorMsg()));
               JError::raiseError(500, JText::_("System error! Contact our administrators."));
           }

		JFactory::getApplication()->enqueueMessage(JText::_("Quotes updated."));
	}
    
	/**
	 * Import items from cvs file
	 *
	 */
    public function import( ) {
        
        // Build the appropriate paths
        $config   =     JFactory::getConfig();
        $tmpDir   =     $config->getValue('config.tmp_path');
        
        jimport('joomla.filesystem.path');
        
        $useMyName    = JRequest::getBool( 'useMyName' );
        $uploadedFile = JRequest::getVar( 'ifile', '', 'files', 'array' );
        
        $file =   $tmpDir . DS . $uploadedFile['name'];
        JPath::check($file);
        
        jimport('joomla.filesystem.file');
        if (!JFile::upload($uploadedFile['tmp_name'], JString::strtolower( $file ))) {

            JError::raiseError( 500, JText::_("You can't upload this file.") );
            
        } 
        
        if ( !JFile::exists( $file ) ) {
            
            JError::raiseError( 500, JText::_("You can't upload this file.") );
            
        }

        $data       =   array();
        $row        =   array();
        $handle     =   fopen($file, "r");
        
        if( !is_resource( $handle ) ) {
            
              JError::raiseError( 500, "You can't upload this file." );
            
        }
        
        // Help fgetcsv() to read in UTF8
        setlocale( LC_ALL, 'en_US.UTF-8' );
        $author = JFactory::getUser()->get('name');
        
        while ( false !== ($row = fgetcsv($handle, 1024, ";"))) {
                if ( !$row[1] AND $useMyName ) {
                	$row[1] = $author;
                }
                $data[] =  $row;
        }
        
        fclose($handle);
        
        $this->insert( $data );
        
        // Delete file
        if (!JFile::delete( $file )) {
            $log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " File ( " . $file . " ) cannot be deleted. "));
            JError::raiseError(500,JText::_("System error!"));
        } 
        
        JFactory::getApplication()->enqueueMessage(JText::_("Quotes imported."));
        
    }
    
    /**
     * Import products
     *
     * @param array $data
     * @return mixed
     */
    private function insert( &$data ) {
        
        $filter             =   JFilterInput::getInstance();
        $user               =   JFactory::getUser();
        
        $query      =   "
                INSERT HIGH_PRIORITY INTO #__vq_quotes
                ( 
                  `quote`,
                  `author`,
                  `category_id`,
                  `published`,
                  `user_id`,
                  `liked`,
                  `data`
                  )
            VALUES ";
        
        $row    =   0;
        foreach ( $data as &$value ) {
        	
            $quote      =   $filter->clean($value[0],"STRING");
            $author     =   $filter->clean($value[1],"STRING");
            $category   =   $filter->clean($value[2],"INTEGER");
            $liked      =   $filter->clean($value[3],"INTEGER");
            $date       =   $filter->clean($value[4]);
            
            // Set loop number ( row )
            $row++;
            
            if ( !$quote ) {
                $log    =   JLog::getInstance();
                $log->addEntry(array("status"=>"Error", "comment"=> " Quote : " . $quote));
                JError::raiseError(500,JText::_("Eventual error on row :" . $row . "."));
                
            }
           
           $queries[]   = "( 
                " . $this->_db->Quote($quote) . ",
                " . $this->_db->Quote($author) . ",
                " . $this->_db->Quote($category) . ",
                0,
                " . $user->get("id") . ",
                " . (int)$liked     . "
                " . $this->_db->Quote($date) . "
                
            )";
           
           
        }
        
        $query  .=   implode(",",$queries);
                
        $this->_db->setQuery($query);
        
        if ( !$this->_db->query() ) {
            $log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Query : (" . $query . ") Error : " . $this->_db->getErrorMsg()));
            JError::raiseError(500,JText::_("System error!"));
        }
        
    }
    
    /**
     * Archive 
     *
     * @return unknown
     */
    public function archive(){
        
        // Build the appropriate paths
        $config   =&  JFactory::getConfig();
        $tmpDir   =   $config->getValue('config.tmp_path');
        
        $this->_db->setQuery('
            SELECT 
	            `quote`,
	            `author`,
	            `category_id`,
	            `liked`,
	            `date`
            FROM    
                `#__vq_quotes`
            ');
        
        $result =   $this->_db->loadRowList();
        
        // Generate unique file code
        jimport('joomla.user.helper');
        $uniqueCode =   JUserHelper::genRandomPassword();
        
        $file   =   $tmpDir . DS. "quotes-" . date('Y-m-d') . '-' . $uniqueCode .'.csv';
        
        $fp = fopen($file, 'w');
        
        foreach ($result as $line) {
            fputcsv($fp, $line, ";");
        }
        
        fclose($fp);
        
        return $file;
    }
    
    /**
     * Backup item when user update it
     *
     * @param TableQuotes $row
     */
    private function backup( $row ) {
    	
    	$query = "
    	
	        INSERT INTO 
	           " . $this->_db->nameQuote("#__vq_history") . "
	        SET 
	            `quote_id`    ="  . $this->_db->Quote($row->id)            . ",
	            `quote`       ="  . $this->_db->Quote($row->quote)         . ",
	            `author`      ="  . $this->_db->Quote($row->author)        . ",
	            `category_id` ="  . $this->_db->Quote($row->category_id)   . ",
	            `user_id`     ="  . $this->_db->Quote($row->user_id)       . ",
	            `liked`       ="  . (int)$row->liked                       . ",
	    	    `date`        ="  . $this->_db->Quote($row->date);
    	
    	$this->_db->setQuery( $query );
    	
        if ( !$this->_db->query() ) {
            $log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Query : (" . $query . ") Error : " . $this->_db->getErrorMsg()));
            JError::raiseError(500,JText::_("System error!"));
        }
    	
    }
    
    /**
     * Load all authors
     *
     * @return array
     */
    public function getAuthors( ) {
    	
        $this->_db->setQuery("
            SELECT DISTINCT 
	           `author` as name
            FROM 
                `#__vq_quotes`
            WHERE 
                `author` !=''
        ");
	        
        $rows =   $this->_db->loadResultArray();
        
        return $rows;
        
    }
}
?>