<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport( 'joomla.application.component.model' );

class ModelHistory extends JModel {
    
    /**
	 * Category ata array
	 *
	 * @var array
	 */
	private $data = null;

	/**
	 * Category total
	 *
	 * @var integer
	 */
	private $total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	private $pagination = null;
	
    public function  __construct() {
        
        parent::__construct();
        
        global $mainframe, $option;

		// Set site limit settings
        if ( !$mainframe->isAdmin() ) {
            // At some point in the future this will come from a request object
            $limitstart = JRequest::getVar('limitstart', 0, '', 'int');
            $limit = $mainframe->getCfg("list_limit");
        } else {
        	
        	// Get the pagination request variables
	        $limit      = $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
	        $limitstart = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . '.limitstart', 'limitstart', 0, 'int' );
        	
        }
        
		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		// Set redirection view
		$app = JFactory::getApplication();
        $app->setUserState("redirect.view", $this->getName());
        $app->setUserState("redirect.layout", "");
    }
    
    
    /**
	 * Method to get payments
	 *
	 * @since 1.5
	 */
	public function getData( )	{

	    $query         =   $this->buildQuery();
	    $this->data    = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
    
		return $this->data;
	}
	
	/**
	 * Method to get a pagination object of the items
	 *
	 * @access public
	 * @return integer
	 */
	public function getPagination()	{
	    
		// Lets load the content if it doesn't already exist
		if (empty($this->pagination))
		{
			jimport('joomla.html.pagination');
			$this->pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->pagination;
	}
    
	/**
	 * Method to get the total number of items
	 *
	 * @access public
	 * @return integer
	 */
	public function getTotal()	{
		// Lets load the content if it doesn't already exist
		if (empty($this->total))
		{
			$query = $this->buildQuery();
			
			$this->total = $this->_getListCount($query);
		}

		return $this->total;
	}
	
	/**
	 * Building query
	 *
	 * @return string
	 */
	public function buildQuery()	{
	    
		// Get the WHERE and ORDER BY clauses for the query
		$where		= $this->buildContentWhere();
		$orderby	= $this->buildContentOrderBy();

		$query  =   "
		SELECT  " . $this->_db->nameQuote("#__vq_history") . ".*,
		        " . $this->_db->nameQuote("#__users") . ".username
        FROM    " . $this->_db->nameQuote("#__vq_history") . ",
                " . $this->_db->nameQuote("#__users");
		
        $query  .= $where;
        $query  .= $orderby;

		return $query;
	}

    /**
     * Build 'order' part of query
     *
     * @return string
     */ 		
    private function buildContentOrderBy()	{
        
		global $mainframe, $option;
        $orderby    =   "";
        
		// Order
        $filter_order		= $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order",		'filter_order',		'name',	'cmd' );
        $filter_order_Dir	= $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order_Dir",	'filter_order_Dir',	'',			'word' );

        if ( $filter_order AND $filter_order_Dir ) {
		  $orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir;
        }

		return $orderby;
	}
	
	/**
     * Build 'where' part of query
     *
     * @return string
     */ 
	public function buildContentWhere()	{
	
		global $mainframe, $option;
		
		$where = array();
		$where[]  =   $this->_db->nameQuote("#__vq_history") . ".user_id=" . $this->_db->nameQuote("#__users") . ".id";
		
		$where = ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );

		return $where;
	}
	
    /**
     * Delete items
     *
     * @param array $cids
     */
    public function delete( $cids ) {
        
    	$userId   =   JFactory::getUser()->get("id");
    	
		// Delete items 
		$query = "
		DELETE  
		FROM  " . $this->_db->nameQuote("#__vq_history") . "
        WHERE   id IN ( " .implode( ',', $cids ). " )";
		
		$this->_db->setQuery( $query );
		
		if(!$this->_db->query()) {
			$log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $this->_db->getErrorMsg()));
            JError::raiseError(500, JText::_("System error!"));
		}
			
		JFactory::getApplication()->enqueueMessage(JText::_("Quotes were deleted."));
        
    }
    
    /**
     * Delete items
     *
     * @param array $cids
     */
    public function recover( $cids ) {
        
        if ( !empty( $cids ) ) {
        	
            $query =  " 
                SELECT * 
                FROM " . $this->_db->nameQuote("#__vq_history") . "
                WHERE   id IN ( " .implode( ',', $cids ). " )";
            
	        $this->_db->setQuery( $query );
	        
	        $rows  =   $this->_db->loadObjectList();
	        
        	foreach ( $rows as $item ) {
        		
        		$query =  " 
                UPDATE  " . $this->_db->nameQuote("#__vq_quotes") . "
                SET     quote="         . $this->_db->Quote($item->quote) . ",
                        author="        . $this->_db->Quote($item->author) . ",
                        category_id="   . $this->_db->Quote($item->category_id) . ",
                        user_id="       . $this->_db->Quote($item->user_id) . ",
                        published=0
                WHERE   id=" . $this->_db->Quote($item->quote_id);
            
                $this->_db->setQuery( $query );
            
	        	if(!$this->_db->query()) {
		            $log    =   JLog::getInstance();
		            $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $this->_db->getErrorMsg()));
		            JError::raiseError(500, JText::_("System error!"));
		        }
        
        	}	

        	//Delete old quotes
            $this->delete($cids);
            	
        }
        
        JFactory::getApplication()->enqueueMessage(JText::_("Quotes were recovered."));
        
    }
    
}
?>