<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport( 'joomla.application.component.model' );

class ModelCategories extends JModel {
    
    public function  __construct() {
        
        parent::__construct();
        
        global $mainframe, $option;
        
        
		// Get the pagination request variables
		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart	= $mainframe->getUserStateFromRequest( "$option." . $this->getName() .'.limitstart', 'limitstart', 0, 'int' );

		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$app = JFactory::getApplication();
        $app->setUserState("redirect.view", "categories");
        $app->setUserState("redirect.layout", "");
    }
    
    /**
     * Store category data
     *
     */
	public function store() {
        
        // Get category table object 
        $row =  $this->getTable();

        $row->id        =   JRequest::getInt("id",0 , "POST" );
        $row->name      =   JRequest::getString("name", "", "POST");
        $row->url       =   JRequest::getString("url", "", "POST");
        $row->published =   JRequest::getInt("published", "", "POST");

        if ( !$row->name ) {
            JError::raiseError(404, JText::_("Enter valid category name, please!") );
        }
        
	    if ( !$row->url ) {
	    	jimport('joomla.utilities.date');
            $date = new JDate();
            $dateTime = $date->toMySQL();
            $dateTime = str_replace(" ", "-",$dateTime);
            $row->url = str_replace(":", "-",$dateTime);
        }
        
        if (!$row->store())  {
            
        	$log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Error : System can't save category."));
            JError::raiseError(500, JText::_("System error!"));
             
        }
		
        // Set next destination
        VqHelper::setNextPage( $this->getName(), "form" );
        
        JFactory::getApplication()->enqueueMessage(JText::_("The category was saved successfully."));
        
    }
    
    /**
     * Delete categories
     *
     */
    public function delete( $cids ) {
        
        if ( count( $cids ) < 1) {
			JError::raiseError(500, JText::_( 'Select category, please!' ) );
		}

		$query = '
		  DELETE 
		  FROM    
		      `#__vq_categories` 
		  WHERE   
		      `id` IN ( '.implode( ',', $cids ).' )';
		
		$this->_db->setQuery( $query );
		
		if(!$this->_db->query()) {
			$log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Error : " . $row->getErrorMsg() ));
            JError::raiseError(500, JText::_("System error!"));
		}
		
		JFactory::getApplication()->enqueueMessage(JText::_("The categories were deleted successfully."));
    }
    
    /**
	 * Method to get data
	 *
	 * @since 1.5
	 */
	public function getData()	{

	    $query         =   $this->buildQuery();
	    $this->data    =   $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
        
		return $this->data;
	}
	
	/**
	 * Method to get a pagination object of the items
	 *
	 * @access public
	 * @return integer
	 */
	public function getPagination()	{
	    
		// Lets load the content if it doesn't already exist
		if (empty($this->pagination)) {
			
			jimport('joomla.html.pagination');
			$this->pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
			
		}

		return $this->pagination;
	}
    
	/**
	 * Method to get the total number of items
	 *
	 * @access public
	 * @return integer
	 */
	public function getTotal()	{
		// Lets load the content if it doesn't already exist
		if (empty($this->total)) {
			
			$query = $this->buildQuery();
			$this->total = $this->_getListCount($query);
		}

		return $this->total;
	}
	
	/**
	 * Building query
	 *
	 * @return string
	 */
	public function buildQuery()	{
	    
		// Get the WHERE and ORDER BY clauses for the query
		$where		= $this->buildContentWhere();
		$orderby	= $this->buildContentOrderBy();

		$query  =   "SELECT  *
                        FROM `#__vq_categories` "
			. $where
			. $orderby
		;

		return $query;
	}

    /**
     * Build 'order' part of query
     *
     * @return string
     */		
    private function buildContentOrderBy()	{
        
		global $mainframe, $option;
        
		$orderby          =   "";
		// Order
        $filter_order	  = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order",		'filter_order',		'name',	'cmd' );
        $filter_order_Dir = $mainframe->getUserStateFromRequest( "$option." . $this->getName() . ".filter_order_Dir",	'filter_order_Dir',	'',			'word' );

        if ( $filter_order AND $filter_order_Dir ) {
		  $orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir;
        }

		return $orderby;
	}
	
	/**
     * Build 'where' part of query
     *
     * @return string
     */ 
	public function buildContentWhere()	{
	    
		$where = array();

		$where 		= ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );

		return $where;
	}
	
    /**
     * Method to (un)publish item
     *
     * @access  public
     * @return  boolean True on success
     * @since   1.5
     */
    public function publish($cids = array(), $publish = 1) {
        
		$query = '
			UPDATE    
			    `#__vq_categories`  
	        SET        
	            `published` = '.(int) $publish . ' 
			WHERE      
			    `id` IN ( '.implode( ',', $cids ) . ")";
		
		$this->_db->setQuery( $query );
		
		if (!$this->_db->query()) {
		    $log    =   JLog::getInstance();
            $log->addEntry(array("status"=>"Error", "comment"=> " Error Message : " . $row->getErrorMsg() ));
            JError::raiseError(500, JText::_("System error!"));
		}

        JFactory::getApplication()->enqueueMessage(JText::_("The categories were updated successfully."));
    }
    
    /**
     * Load categories
     *
     * @param string $index
     * @return array
     */
    public function getCategories( $index = "id" ) {
    	
    	$this->_db->setQuery("
	    	SELECT 
	    	   *
	    	FROM   
	    	   `#__vq_categories` 
	    	WHERE  
	    	   `published` = 1
    	");
    	
    	return $this->_db->loadObjectList($index);
    	
    }
}
?>