<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class ItpUpdate {
	
	public  $currentVersion  = '1.6';
	
	private $queries = array();
	
	public function update() {
		
       $db = JFactory::getDbo();

       // Get old version
       $query  = "
            SELECT 
                `version` 
            FROM 
                `#__vq_meta` 
            WHERE 
                `id`=1";
       
       $version = $db->getOne( $query );
       settype($version,'double');

       if ( !$version ) {
          $version = 1.4;
       }
       
       $version += 0.1;
       
	   switch ( $version ) {
	   	
	   	   case '1.5':
	   	   	   $this->queries[] = "ALTER TABLE `#__vq_categories` ADD COLUMN `url` VARCHAR(128) NOT NULL DEFAULT '0000-00-00' AFTER `name`;";
	   	   	   $this->queries[] = "ALTER TABLE `#__vq_quotes` ADD COLUMN `liked` SMALLINT UNSIGNED NOT NULL DEFAULT 0;";
	   	   	   $this->queries[] = "ALTER TABLE `#__vq_quotes` ADD COLUMN `date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP;";
	   	   	   $this->queries[] = "ALTER TABLE `#__vq_history` ADD COLUMN `liked` SMALLINT UNSIGNED NOT NULL DEFAULT 0 AFTER `user_id`;";
	   	   	   $this->queries[] = "ALTER TABLE `#__vq_history` ADD COLUMN `date` TIMESTAMP NOT NULL DEFAULT 0 AFTER `liked`;";
	   	   	   $this->queries[] = "UPDATE `#__vq_quotes` SET `date` = NOW();";
	   	   	   $this->queries[] = "CREATE TABLE IF NOT EXISTS `#__vq_meta` (
  `id` tinyint(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `version` char(3) NOT NULL,
  PRIMARY KEY(`id`)
)
ENGINE=MYISAM
ROW_FORMAT=default
CHARACTER SET utf8 
COLLATE utf8_general_ci;";
	   	   	   
    
	   }
	   
	   /*** Execute the queries ***/
	   if ( !empty( $this->queries ) ) {
		   foreach ( $this->queries as $query ) {
		   	
		   	   $db->setQuery( $query );
		   	   
			   if(!$db->query()) {
	                jimport( 'joomla.error.log' );
	                $log    =   JLog::getInstance();
	                $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $db->getErrorMsg()));
	                JError::raiseError(500, JText::_("System error!"));
	            }
		   	
		   }
	   }
	   
	// Update current version
      $query  = "
       REPLACE INTO 
           `#__vq_meta` 
       SET 
           `id`=1,
           `version` = " . $db->Quote( $this->currentVersion );
       
      $version = $db->setQuery( $query );
               
      if(!$db->query()) {
          jimport( 'joomla.error.log' );
          $log    =   JLog::getInstance();
          $log->addEntry(array("status"=>"Error", "comment"=> " Query : " . $query . " Error : " . $db->getErrorMsg()));
          JError::raiseError(500, JText::_("System error!"));
       }
       
	}
}
?>