<?php
/******************************************************************************************
* $Id: view.html.php 100 2011-06-03 07:13:39Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.view");
//***************************************************************************************************
class JvleViewLinks extends JView
{
    function display($tpl = null)
    {
        jimport('joomla.html.html');
        JHTML::_('behavior.tooltip');

        $layout = JRequest::getVar('layout');
        switch ($layout)
        {
            case "newone": $this->showNewOneWayForm($tpl); break;
            case "newtwo": $this->showNewTwoWayForm($tpl); break;
            case "editone": $this->showEditOneWayForm($tpl); break;
            case "edittwo": $this->showEditTwoWayForm($tpl); break;
            case "changecat": $this->showChangeCategoryForm($tpl); break;
            case "recipcheck": $this->showReciprocalCheckResults($tpl); break;
            default: $this->displayLinks($tpl); break;
        }
    }
    
    function showChangeCategoryForm($tpl)
    {
        $cfg = JvleCfg::getInstance();
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink); 
        
        $rids = array();
        $rids = JRequest::getVar('cid', null, 'post', 'array');
        $ridslist = implode(",",$rids);
                
        $this->assignRef('cfg', $cfg);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);
        $this->assignRef('ridslist', $ridslist);

        JToolBarHelper::title('JV-LE - Change Category for Links', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }

    function showReciprocalCheckResults($tpl)
    {
        $link_result_msg = $link_partner_url = $link_recip_url = $link_category = array();
        $cfg = JvleCfg::getInstance();
        
        $rids = array();
        $rids = JRequest::getVar('cid', null, 'post', 'array');        
        for ($i=0;$i<count($rids);$i++)
        {
            $link = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$rids[$i]."'");

            array_push($link_partner_url, $link->partner_url);
            array_push($link_recip_url, $link->reciprocal_link_url);
            array_push($link_category, JvleUtil::getCategoryName($link->link_category));
            
            if ($link->link_type == 'TWO-WAY')
            {
                if ($link->reciprocal_link_url != '')
                {
                    $ret = JvleUtil::checkReciprocalLink($link->reciprocal_link_url, $cfg->self_url);
                    switch ($ret)
                    {
                        case 0: {
                            $msg = 'Your link is available and intact in your partner site';
                            $new_status = 'ESTABLISHED';
                            break;
                        }
                        case 1: {
                            $msg = 'Read Error';
                            $new_status = $link->link_status;
                            break;
                        }
                        case 2: {
                            $msg = 'Reciprocal link to your website contains rel=nofollow';
                            $new_status = 'PENDING';
                            break;
                        }
                        case 3: {
                            $msg = 'Reciprocal link to your website does not exist';
                            $new_status = 'PENDING';
                            break;
                        }
                        default: {
                            $msg = 'Unknown Response. Please investigate manually on the reciprocal link';
                            $new_status = $link->link_status;
                            break;
                        }
                    }
                    
                    array_push($link_result_msg, $msg);
                    if ($cfg->rlc_status_update)
                        JvleUtil::changeLinkStatus($rids[$i], $new_status);
                        
                    JvleUtil::updateLastRecipDate($rids[$i]); /* DG:6 */
                }
                else
                    array_push($link_result_msg, 'Reciprocal check not done, as reciprocal link url for this link is empty');    
            }
            else
                array_push($link_result_msg, 'Reciprocal check not done, as this is a ONE-WAY link');
        }
                             
        $this->assignRef('cfg', $cfg);
        $this->assignRef('link_partner_url', $link_partner_url);
        $this->assignRef('link_recip_url', $link_recip_url);
        $this->assignRef('link_category', $link_category);
        $this->assignRef('link_result_msg', $link_result_msg);
        
        JToolBarHelper::title('JV-LE - Reciprocal Check Result for selected Links', 'generic.png');
        JToolBarHelper::back();
        parent::display($tpl);        
    }

    function showNewOneWayForm($tpl)
    {
        $cfg = JvleCfg::getInstance();
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink); 
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);

        JToolBarHelper::title('JV-LE - Add New One-Way Link/Banner', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }    

    function showNewTwoWayForm($tpl)
    {
        $cfg = JvleCfg::getInstance();
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink); 
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);

        JToolBarHelper::title('JV-LE - Exchange Link/Banner', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }    
  
    function showEditOneWayForm($tpl)
    {              
        $id = JRequest::getInt('id', 0);
        if (!$id)
            return;
        
        $cfg = JvleCfg::getInstance();
        $link = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$id."'");
                
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink); 
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('id', $id);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);
        $this->assignRef('link', $link); 

        JToolBarHelper::title('JV-LE - Edit One-Way Link', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }
  
    function showEditTwoWayForm($tpl)
    {              
        $id = JRequest::getInt('id', 0);
        if (!$id)
            return;
        
        $cfg = JvleCfg::getInstance();
        $link = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$id."'");
                
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink); 
        
        $partner_link_loc = JvleBase::getSEFURLForExternal("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=all_category_links&cid=".$link->link_category, 0);
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('id', $id);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);
        $this->assignRef('link', $link);
        $this->assignRef('partner_link_loc', $partner_link_loc);

        JToolBarHelper::title('JV-LE - Edit Two-Way Link', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }
            
    function displayLinks($tpl)         
    {
        $cfg = JvleCfg::getInstance();

        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink);        
        
        $links =& $this->get('Data');
        $pagination =& $this->get('Pagination');        
        
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('cfg', $cfg);
        $this->assignRef('pagination', $pagination);
        $this->assignRef('links', $links);
        $this->assignRef('cidval', JRequest::getInt('cidval', 0));

        JToolBarHelper::title('JV-LE - Links and Banners', 'generic.png');
        JToolBarHelper::addNew('newone', 'Add One-Way Link');
        JToolBarHelper::addNew('newtwo', 'Exchange Link');   
        JToolBarHelper::divider();
        JToolBarHelper::editList('approvelink','Approve');
        JToolBarHelper::editList('rejectlink','Reject'); 
        JToolBarHelper::divider();
        JToolBarHelper::editList('movelink','Change Category');
        JToolBarHelper::editList('recipcheck','Reciprocal Check');
        JToolBarHelper::editList('togglesnap','Toggle Snap Status');
        JToolBarHelper::divider();
        JToolBarHelper::deleteList();
        JToolBarHelper::divider();         
        JToolBarHelper::back();
        parent::display($tpl);         
    }
}