<?php
/******************************************************************************************
* $Id: jvle.postinstall.php 98 2011-06-02 15:52:59Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
// Prevent direct access  
defined('_JEXEC') or die('Restricted access'); 
//************************************************************************************
class JvlePostinstall
{
    function getDbaseVersion()
    {
        $row = JvleDb::getRow("select `version` from `#__jvle_settings`");
        if (!$row)
        {
            $row = JvleDb::getRow("select `version` from `#__jvlinx_settings`");
            if (!$row)
                return 0;
        }
        
        return $row->version;
    }
//***************************************************************************************************
    function getXmlVersion()
    {
        return getPackageVersion();
    }
//***************************************************************************************************
    function getInfo($verstr, &$major, &$minor, &$build)
    {
        $pos = JString::strpos($verstr, "-");
        if ($pos === false)
        {
            $major = (int)JString::substr($verstr, 0, 1);        
            $minor = (int)JString::substr($verstr, 1, 1);
            $build = (int)JString::substr($verstr, 2, 1);
        }
        else
        {
            $major = (int)JString::substr($verstr, 0, 1);        
            $minor = (int)JString::substr($verstr, 2, 1);
            $build = (int)JString::substr($verstr, 10);
        }        
    }
//***************************************************************************************************    
    function execNewinstall($xml_vers, &$retmsg)
    {
        $retmsg = '';
        
        $filename = JPATH_ADMINISTRATOR.DS."components".DS."com_jvle".DS."upgrade".DS."create.sql";
        $fp = @fopen($filename, "r");
        if ($fp == NULL)
        {
            $retmsg = "Error while opening SQL instructions file:  ".$filename."<br />";
            return 0;
        }  
        
        $sql = array();
        while (!feof($fp))
        {
            $data = JString::trim(fgets($fp));
            if ((JString::substr($data, 0, 3) == "---") || (JString::strlen($data) < 5))
                continue;
            
            if (!JvleDb::getUTFSupport())
                $data = str_replace('engine=myisam default charset=utf8', '', $data);
                
            array_push($sql, $data);
        }                
        
        fclose($fp);
        
        for ($i=0;$i<count($sql);$i++)
        {
            if (!JvleDb::update($sql[$i]))
            {
                $retmsg = "Error while running query: ".$sql[$i]."<br />".JvleDb::getErrorMsg();
                return 0;                        
            }
        }

        return 1;
    }
//********************************************************************************************************    
    function execUpgrade($majver, $minver, &$retmsg)
    {
        $retmsg = '';

        $filename = JPATH_ADMINISTRATOR.DS."components".DS."com_jvle".DS."upgrade".DS."up".$majver.$minver."0.sql";
        $fp = @fopen($filename, "r");
        if ($fp == NULL)
            return 1;

        $sql = array();
        while (!feof($fp))
        {
            $data = JString::trim(fgets($fp));
            if ((JString::substr($data, 0, 3) == "---") || (JString::strlen($data) < 5))
                continue;
                
            if (!JvleDb::getUTFSupport())
                $data = str_replace('engine=myisam default charset=utf8', '', $data);
                
            array_push($sql, $data);
        }                
        
        fclose($fp);
        
        for ($i=0;$i<count($sql);$i++)
        {
            if (!JvleDb::update($sql[$i]))
            {
                $retmsg = "Error while running query: ".$sql[$i]."<br />".JvleDb::getErrorMsg();
                return 0;                        
            }
        }

        return 1;
    }
//********************************************************************************************************    
    function minorVersionUpgrade($db_minor, $xml_major, $xml_minor, $xml_build)
    {
        while ($db_minor < $xml_minor)
        {
        	$retmsg = '';
            $db_minor++;
            if (!JvlePostinstall::execUpgrade($xml_major, $db_minor, $retmsg))
            {
                echo $retmsg . 'Error while upgrading<br />';
                echo 'Post installation task failed. Please contact support@jv-extensions.com';
                return false;
            }
            
            $new_xml_vers = $xml_major.'.'.$db_minor.' Build-'.$xml_build;
            JvlePostinstall::updateVersionInDatabase($new_xml_vers);
            echo 'Database version successfully upgraded to '.$new_xml_vers.'<br />';
        }
        
        return true;
    }
//********************************************************************************************************    
    function updateVersionInDatabase($version)
    {
        JvleDb::update("update `#__jvle_settings` set `version` = '".JvleSecure::defendSQL($version)."'");
    }
//********************************************************************************************************  
    function houseKeeping($mode)
    {
        if ($mode == 1)
        {
            $site_root = JURI::root();
            $site_root = (JString::substr($site_root, JString::strlen($site_root)-1, 1) == '/') ? JString::substr($site_root, 0, JString::strlen($site_root)-1) : $site_root;
                    
            $config =& JFactory::getConfig();
            $title = $config->getValue('config.sitename');
            $email = $config->getValue('config.mailfrom');
            $desc = $config->getValue('config.MetaDesc');

            JvleDb::update("update #__jvle_settings set `version` = '".JvlePostinstall::getXmlVersion()."', self_title = '".JvleSecure::defendSQL($title)."', self_url = '".$site_root."', self_desc = '".JvleSecure::defendSQL($desc)."', self_email = '".JvleSecure::defendSQL($email)."'");

            $dirarray = array(JPATH_SITE.DS.'images'.DS.'com_jvle', JPATH_SITE.DS.'images'.DS.'com_jvle'.DS.'banners');                
            for ($i=0;$i<count($dirarray);$i++)
            {
                if (file_exists($dirarray[$i]))
                    continue;

                if (!mkdir($dirarray[$i], 0755))
                {
                    echo 'Create directory failed for '.$dirarray[$i].'. Please create this folder manually<br />';
                    continue;
                }
            
                @copy(_MOS_ABSPATH.DS.'index.html', $dirarray[$i]);                            
            }
        }
        
        return;
    }
//********************************************************************************************************          
    function switch1xTo2x($majorv, $minorv, $buildv)
    {
        $sql = array();
        
        $sql[] = "update #__jvle_settings set rlc_status_update = '1' where rlc_status_update = 'yes'";
        $sql[] = "update #__jvle_settings set rlc_status_update = '0' where rlc_status_update = 'no'";
        $sql[] = "update #__jvle_settings set enable_rlc_fe = '1' where enable_rlc_fe = 'yes'";
        $sql[] = "update #__jvle_settings set enable_rlc_fe = '0' where enable_rlc_fe = 'no'";
        $sql[] = "update #__jvle_settings set auto_approve = '1' where auto_approve = 'yes'";
        $sql[] = "update #__jvle_settings set auto_approve = '0' where auto_approve = 'no'";
        $sql[] = "update #__jvle_settings set show_latest_links = '1' where show_latest_links = 'yes'";
        $sql[] = "update #__jvle_settings set show_latest_links = '0' where show_latest_links = 'no'";
        $sql[] = "update #__jvle_settings set enable_link_rating = '1' where enable_link_rating = 'yes'";
        $sql[] = "update #__jvle_settings set enable_link_rating = '0' where enable_link_rating = 'no'";
        $sql[] = "update #__jvle_settings set display_ratings = '1' where display_ratings = 'yes'";
        $sql[] = "update #__jvle_settings set display_ratings = '0' where display_ratings = 'no'";
        $sql[] = "update #__jvle_settings set enable_search = '1' where enable_search = 'yes'";
        $sql[] = "update #__jvle_settings set enable_search = '0' where enable_search = 'no'";
        $sql[] = "update #__jvle_settings set fe_addlink = '1' where fe_addlink = 'yes'";
        $sql[] = "update #__jvle_settings set fe_addlink = '0' where fe_addlink = 'no'";
        $sql[] = "update #__jvle_settings set email_approval = '1' where email_approval = 'yes'";
        $sql[] = "update #__jvle_settings set email_approval = '0' where email_approval = 'no'";
        $sql[] = "update #__jvle_settings set enable_checklinkstatus = '1' where enable_checklinkstatus = 'yes'";
        $sql[] = "update #__jvle_settings set enable_checklinkstatus = '0' where enable_checklinkstatus = 'no'";
        $sql[] = "update #__jvle_settings set enable_recweb = '1' where enable_recweb = 'yes'";
        $sql[] = "update #__jvle_settings set enable_recweb = '0' where enable_recweb = 'no'";
        $sql[] = "update #__jvle_settings set enable_ads = '1' where enable_ads = 'yes'";
        $sql[] = "update #__jvle_settings set enable_ads = '0' where enable_ads = 'no'";
        $sql[] = "update #__jvle_settings set enable_snap = '1' where enable_snap = 'yes'";
        $sql[] = "update #__jvle_settings set enable_snap = '0' where enable_snap = 'no'";
        $sql[] = "update #__jvle_settings set enable_captcha = '1' where enable_captcha = 'yes'";
        $sql[] = "update #__jvle_settings set enable_captcha = '0' where enable_captcha = 'no'";
        $sql[] = "update #__jvle_settings set enable_scheduler = '1' where enable_scheduler = 'yes'";
        $sql[] = "update #__jvle_settings set enable_scheduler = '0' where enable_scheduler = 'no'";
        $sql[] = "update #__jvle_settings set window_new = '1' where window_new = 'yes'";
        $sql[] = "update #__jvle_settings set window_new = '0' where window_new = 'no'";
        $sql[] = "update #__jvle_settings set enable_flinks = '1' where enable_flinks = 'yes'";
        $sql[] = "update #__jvle_settings set enable_flinks = '0' where enable_flinks = 'no'";
        $sql[] = "update #__jvle_settings set fe_addbanner = '1' where fe_addbanner = 'yes'";
        $sql[] = "update #__jvle_settings set fe_addbanner = '0' where fe_addbanner = 'no'";
        $sql[] = "update #__jvle_links set snap_status = '1' where snap_status = 'on'";
        $sql[] = "update #__jvle_links set snap_status = '0' where snap_status = 'off'";
        $sql[] = "update #__jvle_links set enable_scheduler = '1' where enable_scheduler = 'yes'";
        $sql[] = "update #__jvle_links set enable_scheduler = '0' where enable_scheduler = 'no'";
        $sql[] = "update #__jvle_categories set snap_status = '1' where snap_status = 'on'";
        $sql[] = "update #__jvle_categories set snap_status = '0' where snap_status = 'off'";
        $sql[] = "update #__jvle_categories set accept_links = '1' where accept_links = 'yes'";
        $sql[] = "update #__jvle_categories set accept_links = '0' where accept_links = 'no'";
        $sql[] = "update #__jvle_categories set visibility = '1' where visibility = 'on'";
        $sql[] = "update #__jvle_categories set visibility = '0' where visibility = 'off'";

        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `version` `version` VARCHAR(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `site_title` `self_title` VARCHAR(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `site_url` `self_url` VARCHAR(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `site_desc` `self_desc` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `site_email` `self_email` VARCHAR(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `rlc_status_update` `rlc_status_update` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_rlc_fe` `enable_rlc_fe` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `auto_approve` `auto_approve` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `show_latest_links` `show_latest_links` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_link_rating` `enable_link_rating` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `display_ratings` `display_ratings` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_search` `enable_search` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `switch_gpr`";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `switch_atr`";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `fe_addlink` `fe_addlink` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `fe_title` `fe_title` VARCHAR(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `fe_catformat`";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `email_approval` `email_approval` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_checklinkstatus` `enable_checklinkstatus` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_recweb` `enable_recweb` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `show_fe_gpr`"; 
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_ads` `enable_ads` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_snap` `enable_snap` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_captcha` `enable_captcha` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_scheduler` `enable_scheduler` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `window_new` `window_new` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `enable_flinks` `enable_flinks` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `flinks_loc`"; 
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `flinks_numshow` `flinks_numshow` TINYINT NOT NULL DEFAULT '5'";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `flinks_style`"; 
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `flinks_subamount` `flinks_subamount` FLOAT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` CHANGE `fe_addbanner` `fe_addbanner` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `xchange_type`";                                           
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `autoxchange_subid`";                                           
        $sql[] = "ALTER TABLE `#__jvle_settings` DROP `autoxchange_webid`";
        $sql[] = "ALTER TABLE `#__jvle_settings` ADD `generic_reject_reason` LONGTEXT NOT NULL";                                           
        $sql[] = "ALTER TABLE `#__jvle_settings` ADD `header_slogan` VARCHAR(80) NOT NULL DEFAULT ''";
        $sql[] = "ALTER TABLE `#__jvle_settings` ADD `show_flinks` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_links` CHANGE `partner_title` `partner_title` VARCHAR(80) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
        $sql[] = "ALTER TABLE `#__jvle_links` CHANGE `snap_status` `snap_status` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_links` CHANGE `enable_scheduler` `enable_scheduler` TINYINT NOT NULL DEFAULT '0'";
        $sql[] = "ALTER TABLE `#__jvle_categories` CHANGE `snap_status` `snap_status` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_categories` CHANGE `accept_links` `accept_links` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "ALTER TABLE `#__jvle_categories` CHANGE `visibility` `visibility` TINYINT NOT NULL DEFAULT '1'";
        $sql[] = "DROP TABLE `#__jvle_captcha`";
        
        for ($j=1,$i=0;$i<count($sql);$i++,$j++)       
        {
            if (!JvleDb::update($sql[$i]))
            {
                echo 'Database error encountered - '.JvleDb::getErrorMsg().' - Sql: '.$sql[$i];
                return false;
            }
        }
        
        $dirarray = array(JPATH_SITE.DS.'images'.DS.'com_jvle', JPATH_SITE.DS.'images'.DS.'com_jvle'.DS.'banners');                
        for ($i=0;$i<count($dirarray);$i++)
        {
            if (file_exists($dirarray[$i]))
                continue;

            if (!mkdir($dirarray[$i], 0755))
            {
                echo 'Create directory failed for '.$dirarray[$i].'. Please create this folder manually<br />';
                continue;
            }
        
            @copy(_MOS_ABSPATH.DS.'index.html', $dirarray[$i]);                            
        }
                
        $new_xml_vers = $majorv.'.'.$minorv.' Build-'.$buildv;
        JvlePostinstall::updateVersionInDatabase($new_xml_vers);
        echo 'Database version successfully upgraded to '.$new_xml_vers.'<br />';    
        
        return true;
    }
//********************************************************************************************************        
}