<?php
/******************************************************************************************
* $Id: install.jvle.php 98 2011-06-02 15:52:59Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
//***************************************************************************************************
function com_install()
{
    require_once(JPATH_ADMINISTRATOR.DS."components".DS."com_jvle".DS."common".DS."jvle.resources.php"); 
    require_once(JPATH_ADMINISTRATOR.DS."components".DS."com_jvle".DS."version.php");
    require_once(JPATH_ADMINISTRATOR.DS."components".DS."com_jvle".DS."libraries".DS."jvle.postinstall.php");
            
    echo '<h3><b>JV-LE Installation completed successfully...</b></h3><br/><hr/>';
    echo '<h3><b>Starting JV-LE Post-Installation task...</b></h3><br />';

    $db_vers = JvlePostinstall::getDbaseVersion();       
    echo 'JV-LE Version in Database: '.$db_vers.'<br />';
    $xml_vers = JvlePostinstall::getXmlVersion();        
    echo 'JV-LE Version in Files: '.$xml_vers.'<br /><br/>';

    $retmsg = "";
    if (!$db_vers)
    {
        echo 'Initiating a new database installation for JV-LE...<br />';
        if (!JvlePostinstall::execNewinstall($xml_vers, $retmsg))
        {
            echo $retmsg . 'Error during post installation<br />';
            echo 'Post installation task failed. Please contact support@jv-extensions.com';
            return false;
        }
        else
        {    
            JvlePostinstall::updateVersionInDatabase($xml_vers);            
            JvlePostinstall::houseKeeping(1); 
            
            echo 'Database tables have been successfully installed. Version: '.JvlePostinstall::getDbaseVersion().'<br /><br />';
            echo 'Post Installation script run completed successfully';
            return true;
        }        
    }
    
    $db_major = $db_minor = $db_build = $xml_major = $xml_minor = $xml_build = 0;
    JvlePostinstall::getInfo($db_vers, $db_major, $db_minor, $db_build);
    JvlePostinstall::getInfo($xml_vers, $xml_major, $xml_minor, $xml_build);
    
    if ($db_major == 1)
    {
        $version_in_use = $db_build + (10 * $db_minor) + (100 * $db_major);
        if ($version_in_use < 128)
        {
            echo 'You must be running atleast JV-LE 1.2.8 to upgrade to JV-LE 2.x. Please upgrade to v1.2.8 before you attempt to upgrade to 2.x versions<br />';
            return false;
        }
        
        if (JvlePostinstall::switch1xTo2x($xml_major, $xml_minor, $xml_build) == false)
        {            
            echo 'Error while upgrading<br />';
            echo 'Post installation task failed. Please contact support@jv-extensions.com';                
            return false;
        }
                
        echo 'Database tables have been successfully installed. Version: '.JvlePostinstall::getDbaseVersion().'<br /><br />';
        echo 'Post Installation script run completed successfully';
        return true;
    }

    if ($xml_major != $db_major)
    {
        echo 'You are attempting a major version upgrade. Please contact support@jv-extensions.com to know the procedure for major version upgrade.<br />';
        echo 'Post Installation script failed'; 
        return false;       
    }
    
    if ($xml_minor < $db_minor)
    {
        echo 'Inconsistency in minor versions of JV-LE database and filesystem detected<br />';
        echo 'Post installation task failed. Please contact support@jv-extensions.com';
        return false;            
    }   
    
    if ($xml_minor > $db_minor)
    {
        echo 'Initiating a minor version upgrade of the JV-LE database to the latest version...<br />';            
        if (JvlePostinstall::minorVersionUpgrade($db_minor, $xml_major, $xml_minor, $xml_build) == false)
        {            
            echo $retmsg . 'Error while upgrading<br />';
            echo 'Post installation task failed. Please contact support@jv-extensions.com';                
            return false;
        }
        
        JvlePostinstall::houseKeeping(2);
            
        echo 'Post Installation script run completed successfully. Database version: '.JvlePostinstall::getDbaseVersion().'<br /><br />';
        return true;        
    }
    
    JvlePostinstall::updateVersionInDatabase($xml_vers);
    echo 'Post Installation script run completed successfully. Database version: '.JvlePostinstall::getDbaseVersion().'<br /><br />';
    return true;
}