<?php
/******************************************************************************************
* $Id: links.php 100 2011-06-03 07:13:39Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.controller");
#*****************************************************************************************
class JvleControllerLinks extends JController {

    function __construct() 
    {        
        parent::__construct();        

        if (_JVLE_J16)
            JvleAdminUtil::addSubmenu();                        
    }
    
    function display() 
    {
        JRequest::setVar('view', 'links');        
        JRequest::setVar('layout', 'default');        
        parent::display();
    }

    function togglesnap()
    {
        $model =& $this->getModel('Links');    
        $model->toggleSnap();
        $this->setRedirect('index.php?option=com_jvle&controller=links', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }
    
    function remove()
    {
        $model =& $this->getModel('Links');    
        $model->deleteLinks();
        $this->setRedirect('index.php?option=com_jvle&controller=links', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }   
    
    function approvelink()
    {
        $model =& $this->getModel('Links');    
        $model->approveLinks();
        $this->setRedirect('index.php?option=com_jvle&controller=links', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }   
    
    function rejectlink()
    {
        $model =& $this->getModel('Links');    
        $model->rejectLinks();
        $this->setRedirect('index.php?option=com_jvle&controller=links', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }
    
    function movelink()
    {
        JRequest::setVar('view', 'Links');
        JRequest::setVar('layout', 'changecat');
        parent::display();
    }
    
    function recipcheck()
    {
        $rids = array();
        $rids = JRequest::getVar('cid', null, 'post', 'array');
        if (!count($rids))
        {
            $this->setRedirect('index.php?option=com_jvle&controller=links', 'Please select atleast one link', 'error');    
            return;
        }
        
        if (count($rids) > 10)        
        {
            $this->setRedirect('index.php?option=com_jvle&controller=links', 'You can only select a maximum of 10 links at a time, to check for backlinks', 'error');    
            return;            
        }
        
        JRequest::setVar('view', 'Links');
        JRequest::setVar('layout', 'recipcheck');
        parent::display();
    }    
    
    function cancel() 
    {
        $this->setRedirect('index.php?option=com_jvle&controller=links');
    }                  
    
    function save() 
    {
        JvleSecure::defendCSRF();
        $model =& $this->getModel('Links');
        $model->store();
        $this->setRedirect('index.php?option=com_jvle&controller=links', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }

    function newone()
    {
        JRequest::setVar('view', 'Links');
        JRequest::setVar('layout', 'newone');
        parent::display();
    }
    
    function newtwo()
    {
        JRequest::setVar('view', 'Links');
        JRequest::setVar('layout', 'newtwo');
        parent::display();
    }
    
    function update()
    {
        JRequest::setVar('view', 'Links');
        
        $id = JRequest::getInt('id', 0);
        if (!$id)
        {
            $this->setRedirect('index.php?option=com_jvle&controller=links', 'Invalid Request', 'error');    
            return;     
        }
        
        $type = JvleDb::getValue("select link_type from #__jvle_links where id = '".(int)$id."'");
        $layout = ($type == 'ONE-WAY') ? 'editone' : 'edittwo';
        
        JRequest::setVar('layout', $layout);
        parent::display();
    }
}