<?php
/******************************************************************************************
* $Id: config.php 100 2011-06-03 07:13:39Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.controller");
#*****************************************************************************************
class JvleControllerConfig extends JController {

    function __construct() 
    {        
        parent::__construct();

        if (_JVLE_J16) {
            $user = JFactory::getUser();
            if (!$user->authorise('core.admin', 'com_jvle')) {
                JError::raiseWarning(403, JText::_('JERROR_ALERTNOAUTHOR'));
                $this->setRedirect('index.php?option=com_jvle');
            }
            
            JvleAdminUtil::addSubmenu();
        }
    }

    function display() 
    {
        JRequest::setVar('view', 'config');        
        JRequest::setVar('layout', 'default');        
        parent::display();
    }

    function save() 
    {
        JvleSecure::defendCSRF();
        $model =& $this->getModel('Config');
        $model->store();
        $this->setRedirect('index.php?option=com_jvle', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }

    function apply() 
    {
        JvleSecure::defendCSRF();
        $model =& $this->getModel('Config');
        $model->store();
        $this->setRedirect('index.php?option=com_jvle&controller=config', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }

    function cancel() 
    {
        $this->setRedirect('index.php?option=com_jvle');
    }
}