<?php
/******************************************************************************************
* $Id: category.php 100 2011-06-03 07:13:39Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.controller");
#*****************************************************************************************
class JvleControllerCategory extends JController {

    function __construct() 
    {        
        parent::__construct();
        
        if (_JVLE_J16)
            JvleAdminUtil::addSubmenu();                        
    }
    
    function add()
    {
        JRequest::setVar('view', 'category');
        JRequest::setVar('layout', 'new');
        parent::display();
    }    

    function update()
    {
        JRequest::setVar('view', 'category');
        JRequest::setVar('layout', 'update');
        parent::display();
    }    

    function display() 
    {
        JRequest::setVar('view', 'category');        
        JRequest::setVar('layout', 'default');        
        parent::display();
    }
    
    function togglesnap()
    {
        $model =& $this->getModel('Category');    
        $model->toggleSnap();
        $this->setRedirect('index.php?option=com_jvle&controller=category', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }
    
    function remove()
    {
        $model =& $this->getModel('Category');    
        $model->deleteCategories();
        $this->setRedirect('index.php?option=com_jvle&controller=category', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }    

    function save() 
    {
        JvleSecure::defendCSRF();
        $model =& $this->getModel('Category');
        $model->store();
        $this->setRedirect('index.php?option=com_jvle&controller=category', $model->retobj->getMsg(), $model->retobj->getMsgTS());
    }

    function cancel() 
    {
        $this->setRedirect('index.php?option=com_jvle');
    }
}