<?php
/******************************************************************************************
* $Id: jvle.utilities.php 25 2010-03-29 04:08:31Z nvijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
#*****************************************************************************************
class JvleThumbnail {
	var $cfg;
	var $provider = 0;
	var $url = '';

	function __construct($cfg, $url) {
		$this->cfg = $cfg;
		$this->provider = $cfg->tp_enable;
		$this->url = $url;
	}
	
	function getThumbnail($pg) {
		if ($this->provider == 1) {
			if ($this->cfg->stw_access_key == '')
				return '';
			
			switch ($pg) {
				case _JVLE_FEATUREDLINK_PAGE: $size = 'lg'; break;
				case _JVLE_GENCATEGORY_PAGE: $size = 'sm'; break;
				case _JVLE_LATLINKS_PAGE: $size = 'vsm'; break;
				case _JVLE_SEARCHRESULTS_PAGE: $size = 'tny'; break;
				default: $size = 'sm'; break;
			}
			
			return '<style type="text/css">.jvle_stwimg {width:auto; float:left; margin-right:6px;}</style>
					<script type="text/javascript" src="http://www.shrinktheweb.com/scripts/pagepix.js?'.time().'"></script>
					<div class="jvle_stwimg">
						<script type="text/javascript">stw_pagepix("'.$this->url.'", "'.$this->cfg->stw_access_key.'", "'.$size.'");</script>
					</div>';				
		}
		else if ($this->provider == 2) {
			if ($this->cfg->websnapr_api_key == '')
				return '';
								
			switch ($pg) {
				case _JVLE_FEATUREDLINK_PAGE: $size = 's'; break;
				case _JVLE_GENCATEGORY_PAGE: $size = 't'; break;
				case _JVLE_LATLINKS_PAGE: $size = 't'; break;
				case _JVLE_SEARCHRESULTS_PAGE: $size = 't'; break;
				default: $size = 't'; break;
			}
				
			return '<style type="text/css">.jvle_stwimg {width:auto; float:left; margin-right:6px;}</style>
					<script type="text/javascript" src="http://www.websnapr.com/js/websnapr.js"></script>
					<div class="jvle_stwimg">
						<script type="text/javascript">wsr_snapshot("'.$this->url.'", "'.$this->cfg->websnapr_api_key.'", "'.$size.'");</script>
					</div>';				
		}
		else
			return '';
	}
}