<?php
/******************************************************************************************
* $Id: jvle.resources.php 113 2011-07-24 05:45:35Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access');
#************************************************************************************************************
define("_JVLE_FEATUREDLINK_PAGE", 0);
define("_JVLE_GENCATEGORY_PAGE", 1);
define("_JVLE_LATLINKS_PAGE", 2);
define("_JVLE_SEARCHRESULTS_PAGE", 3);
#*****************************************************************************************
abstract class JvleDb
{
    public static function getRows($sql)
    {
        $database =& JFactory::getDBO();
        $database->setQuery($sql);
        return $database->loadObjectList();
    }

    public static function getRow($sql)
    {
        $database =& JFactory::getDBO();
        $database->setQuery($sql);
        return $database->loadObject();
    }

    public static function getCount($sql)
    {
        $database =& JFactory::getDBO();
        $database->setQuery($sql);
        return $database->loadResult();
    }
    
    public static function update($sql)
    {
        $database =& JFactory::getDBO();
        $database->setQuery($sql);
        if (!$database->query())
            return 0;
        return 1;
    }
    
    public static function getValue($sql)
    {
        $database =& JFactory::getDBO();
        $database->setQuery($sql);
        return $database->loadResult();
    }
    
    public static function Quote($text) {
        $database =& JFactory::getDBO();
        return $database->Quote($text);
    } 
    
    public static function getUTFSupport() {
        $database =& JFactory::getDBO();
        return $database->getUTFSupport();
    }
    
    public static function getErrorMsg() {
        $database =& JFactory::getDBO(); 
        return $database->getErrorMsg();
    }        
}
#************************************************************************************************************
abstract class JvleSecure
{
    public static function defendCSRF($type="post")
    {
        if ($type == "post")
            JRequest::checkToken() or jexit('Invalid Token');
        else
            JRequest::checkToken('get') or jexit('Invalid Token');
    }

    public static function defendSQL($param, $dos_attack=0)
    {
        $database =& JFactory::getDBO();
        return ($dos_attack) ? $database->getEscaped($param, true) : $database->getEscaped($param); 
    }
}
#***********************************************************************************************
class JvleCfg 
{
	private static $_instance = null;
	private $_config;
	 
	private function __construct() {
		$this->_config = JvleDb::getRow("select * from #__jvle_settings");
	}

	public static function getInstance() {
		if (!self::$_instance) {
			self::$_instance = new JvleCfg;
		}

		return self::$_instance;
	}

	public function __get($var) {
		return (isset($this->_config->$var)) ? $this->_config->$var : "";
	}
}    
#***********************************************************************************************
abstract class JvleBase
{
    public static function getItemid()
    {
        return JvleDb::getValue("select id from #__menu where link = 'index.php?option=com_jvle&view=jvle' and type = 'component' and published = '1'");
    }

    public static function getSEFURLForExternal($nonsefurl, $site=1)
    {
    	$uri =& JFactory::getURI();
    	$url = JRoute::_($nonsefurl, false);
    	if (!$site)
    		$url = JString::str_ireplace("/administrator/", "/", $url);
    	 
    	return $uri->toString(array('scheme', 'host', 'port')).$url;
    }
}
#***********************************************************************************************    
if (!defined("_JVLE_J16")) 
{
    $j16_srcbase = array("1.6", "1.7", "2.5");
    $jvleJoomlaVersion = new JVersion();
    $jvleJoomlaVersion = JString::substr($jvleJoomlaVersion->getShortVersion(), 0, 3);
    if (in_array($jvleJoomlaVersion, $j16_srcbase))
        define("_JVLE_J16", 1);
    else
        define("_JVLE_J16", 0);
}
#***********************************************************************************************