<?php
/**
 * Import path options
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_image.php 1601 2011-06-22 08:38:19Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_GENERAL_IMAGES'); ?></legend>
	<table class="admintable">
		<tbody>
		<!-- See if user wants to process images -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_PROCESS_IMAGE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_PROCESS_IMAGE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_PROCESS_IMAGE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('select.booleanlist', 'jform[image][process_image]', null, $this->template->getValue('process_image', 'image', true), 'yes', 'no', true); ?>
			</td>
		</tr>
		<!-- Auto generate image names -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('select.booleanlist', 'jform[image][auto_generate_image_name]', null, $this->template->getValue('auto_generate_image_name', 'image'), 'yes', 'no', true); ?>
			</td>
		</tr>

		<!-- Create image name based on -->
		<tr id="generate_image_name_row" style="display: <?php echo ($this->template->getValue('auto_generate_image_name', 'image')) ? 'table-row' : 'none'; ?>">
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_TYPE_GENERATE_IMAGE_NAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_TYPE_GENERATE_IMAGE_NAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_TYPE_GENERATE_IMAGE_NAME_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['type_generate_image_name']; ?>
			</td>
		</tr>

		<!-- Auto generate image name extension -->
		<tr id="auto_generate_image_name_ext_row" style="display: <?php echo ($this->template->getValue('auto_generate_image_name', 'image')) ? 'table-row' : 'none'; ?>">
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_EXT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_EXT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_GENERATE_IMAGE_NAME_EXT_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['autogenerateext']; ?>
			</td>
		</tr>

		<!-- Change case -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_GENERATE_IMAGE_NAME_CASE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_GENERATE_IMAGE_NAME_CASE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_GENERATE_IMAGE_NAME_CASE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['change_case']; ?>
			</td>
		</tr>

		<!-- Empty image -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EMPTY_IMAGE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EMPTY_IMAGE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EMPTY_IMAGE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('select.booleanlist', 'jform[image][empty_image]', null, $this->template->getValue('empty_image', 'image'), 'yes', 'no', true); ?>
			</td>
		</tr>
		</tbody>
	</table>
</fieldset>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FULL_IMAGES'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Leave original image -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_KEEP_ORIGINAL_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_KEEP_ORIGINAL_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_KEEP_ORIGINAL_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[image][keep_original]', null, $this->template->getValue('keep_original', 'image'), 'yes', 'no', true); ?>
				</td>
			</tr>
			<!-- Convert images -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_CONVERT_IMAGE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_CONVERT_IMAGE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_CONVERT_IMAGE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['converttype']; ?>
				</td>
			</tr>

			<!-- Save images on server -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_SAVE_IMAGES_ON_SERVER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_SAVE_IMAGES_ON_SERVER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_SAVE_IMAGES_ON_SERVER_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[image][save_images_on_server]', null, $this->template->getValue('save_images_on_server', 'image'), 'yes', 'no', true); ?>
				</td>
			</tr>
			<!-- Full image resize -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_FULL_IMAGE_RESIZE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_FULL_IMAGE_RESIZE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_FULL_IMAGE_RESIZE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[image][full_resize]', null, $this->template->getValue('full_resize', 'image'), 'yes', 'no', true); ?>
				</td>
			</tr>

			<!-- Image size -->
			<tr id="image_size_row" style="display: <?php echo ($this->template->getValue('full_resize', 'image')) ? 'table-row' : 'none'; ?>">
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_FULL_WIDTH_HEIGHT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_FULL_WIDTH_HEIGHT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_FULL_WIDTH_HEIGHT_LABEL'); ?></span>
				</td>
				<td>
					<input class="template_input thumbs" type="text" maxlength="4" id="thumb_width" name="jform[image][full_width]" value="<?php echo $this->template->getValue('full_width', 'image');?>">
					<span class="template_img_symbol">x</span>
					<input class="thumbs" type="text" maxlength="4" id="full_height" name="jform[image][full_height]" value="<?php echo $this->template->getValue('full_height', 'image'); ?>">
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_THUMB_IMAGES'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Check thumbnail file type -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_THUMB_CHECK_FILETYPE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_THUMB_CHECK_FILETYPE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_THUMB_CHECK_FILETYPE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[image][thumb_check_filetype]', null, $this->template->getValue('thumb_check_filetype', 'image'), 'yes', 'no', true); ?>
				</td>
			</tr>
			<!-- Automatic thumbnail creation -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_AUTOMATIC_THUMBNAIL_CREATION_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_AUTOMATIC_THUMBNAIL_CREATION_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_AUTOMATIC_THUMBNAIL_CREATION_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[image][thumb_create]', null, $this->template->getValue('thumb_create', 'image'), 'yes', 'no', true); ?>
				</td>
			</tr>

			<!-- Thumbnail format -->
			<tr id="thumbnailformat_row" style="display: <?php echo ($this->template->getValue('thumb_create', 'image')) ? 'table-row' : 'none'; ?>">
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_FORMAT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_FORMAT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_FORMAT_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['thumbnailformat']; ?>
				</td>
			</tr>

			<!-- Thumbnail size -->
			<tr id="thumb_height_row" style="display: <?php echo ($this->template->getValue('thumb_create', 'image')) ? 'table-row' : 'none'; ?>">
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_WIDTH_HEIGHT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_WIDTH_HEIGHT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_THUMBNAIL_WIDTH_HEIGHT_LABEL'); ?></span>
				</td>
				<td>
					<input class="template_input thumbs" type="text" maxlength="4" id="thumb_width" name="jform[image][thumb_width]" value="<?php echo $this->template->getValue('thumb_width', 'image', '90');?>">
					<span class="template_img_symbol">x</span>
					<input class="thumbs" type="text" maxlength="4" id="thumb_height" name="jform[image][thumb_height]" value="<?php echo $this->template->getValue('thumb_height', 'image', '90'); ?>">
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<script type="text/javascript">
jQuery("input[name='jform[image][auto_generate_image_name]']").live('click', function() {
	if (jQuery("input[name='jform[image][auto_generate_image_name]']:checked").val() == 1) {
		jQuery('#generate_image_name_row, #auto_generate_image_name_ext_row').show();
	}
	else {
		jQuery('#generate_image_name_row, #auto_generate_image_name_ext_row').hide();
	}
})

jQuery("input[name='jform[image][thumb_create]']").live('click', function() {
	if (jQuery("input[name='jform[image][thumb_create]']:checked").val() == 1) {
		jQuery('#thumbnailformat_row, #thumb_height_row').show();
	}
	else {
		jQuery('#thumbnailformat_row, #thumb_height_row').hide();
	}
})

jQuery("input[name='jform[image][full_resize]']").live('click', function() {
	if (jQuery("input[name='jform[image][full_resize]']:checked").val() == 1) {
		jQuery('#image_size_row').show();
	}
	else {
		jQuery('#image_size_row').hide();
	}
})
</script>