<?php
/**
 * General import options
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_general.php 1610 2011-07-30 15:55:39Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_SOURCE_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Choose file on user system -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_FILE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_FILE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_FILE_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('loadfrom', 'general') == 'fromupload' || $this->template->getValue('loadfrom', 'general', false) == false) $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<input type="radio" name="jform[general][loadfrom]" id="fromupload" value="fromupload" <?php echo $checked; ?> onClick="jQuery('.importserver, .importftp, .importurl').hide(); jQuery('.importupload').show();" />
				</td>
			</tr>
			<tr class="importupload" <?php echo $showoption; ?>>
				<td class="key">
				</td>
				<td>
					<input type="file" name="import_file" id="file" size="120" />
				</td>
			</tr>
			<!-- Choose file on server -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_SERVER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_SERVER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_SERVER_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('loadfrom', 'general') == 'fromserver') $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<?php $checked = ($this->template->getValue('loadfrom', 'general') == 'fromserver') ? 'checked="checked"' : ''; ?>
					<input type="radio" name="jform[general][loadfrom]" id="fromserver" value="fromserver" <?php echo $checked; ?> onClick="jQuery('.importupload, .importftp, .importurl').hide(); jQuery('.importserver').show();" />
				</td>
			</tr>
			<tr class="importserver" <?php echo $showoption; ?>>
				<td class="key">
				</td>
				<td>
					<input type="text" size="120" value="<?php echo $this->template->getValue('local_csv_file', 'general', JPath::clean(JPATH_SITE, '/')); ?>" name="jform[general][local_csv_file]" />
				</td>
			</tr>
			<!-- Choose file from URL -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_URL_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_URL_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_URL_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('loadfrom', 'general') == 'fromurl') $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<?php $checked = ($this->template->getValue('loadfrom', 'general') == 'fromurl') ? 'checked="checked"' : ''; ?>
					<input type="radio" name="jform[general][loadfrom]" id="fromurl" value="fromurl" <?php echo $checked; ?> onClick="jQuery('.importupload, .importftp, .importserver').hide(); jQuery('.importurl').show();" />
				</td>
			</tr>
			<tr class="importurl" <?php echo $showoption; ?>>
				<td class="key">
				</td>
				<td>
					<input type="text" size="120" value="<?php echo $this->template->getValue('urlfile', 'general'); ?>" name="jform[general][urlfile]" />
				</td>
			</tr>
			<!-- Choose file on FTP -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_FTP_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_FTP_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FROM_FTP_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('loadfrom', 'general') == 'fromftp') $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<input type="radio" name="jform[general][loadfrom]" id="fromftp" value="fromftp" <?php echo $checked; ?> onClick="jQuery('.importupload, .importserver, .importurl').hide(); jQuery('.importftp').show();" />
				</td>
			</tr>
			<!-- FTP Host -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftphost]" value="<?php echo $this->template->getValue('ftphost', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Port -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[general][ftpport]" value="<?php echo $this->template->getValue('ftpport', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Username -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftpusername]" value="<?php echo $this->template->getValue('ftpusername', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Password -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="password" name="jform[general][ftppass]" value="<?php echo $this->template->getValue('ftppass', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Root -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftproot]" value="<?php echo $this->template->getValue('ftproot', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP filename -->
			<tr class="importftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FTP_FILENAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FTP_FILENAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FTP_FILENAME_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftpfile]" value="<?php echo $this->template->getValue('ftpfile', 'general'); ?>" />
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_FILE_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Auto detect delimiters -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_DELIMITER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_DELIMITER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_AUTO_DELIMITER_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][auto_detect_delimiters]', '', $this->template->getValue('auto_detect_delimiters', 'general', 1)); ?>
				</td>
			</tr>
			<!-- Field delimiter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_LABEL'); ?></span>
				</td>
				<td>
					<input class="delimiter" type="text" maxlength="1" id="field_delimiter" name="jform[general][field_delimiter]" value="<?php echo $this->template->getValue('field_delimiter', 'general', ','); ?>">
				</td>
			</tr>
			<!-- Text enclosure -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_LABEL'); ?></span>
				<td>
				<input class="delimiter" type="text" maxlength="1" id="text_enclosure" name="jform[general][text_enclosure]"
					<?php
						if ($this->template->getValue('text_enclosure', 'general', '"') == '"') echo "value='".$this->template->getValue('text_enclosure', 'general', '"')."'";
						else echo 'value="'.$this->template->getValue('text_enclosure', 'general').'"';
					?>
				/>
				</td>
			</tr>
			<!-- Category separator -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_LABEL'); ?></span>
				<td>
				<input class="delimiter" type="text" id="category_separator" name="jform[general][category_separator]" value="<?php echo $this->template->getValue('category_separator', 'general', '/'); ?>" />
				</td>
			</tr>
			<!-- I'm a Mac -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IM_MAC_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IM_MAC_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IM_MAC_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][im_mac]', '', $this->template->getValue('im_mac', 'general', 0)); ?>
				</td>
			</tr>
			<!-- Use column headers -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_USE_COLUMN_HEADERS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_USE_COLUMN_HEADERS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_USE_COLUMN_HEADERS_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][use_column_headers]', '', $this->template->getValue('use_column_headers', 'general', 1)); ?>
				</td>
			</tr>
			<!-- Skip first line -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_FIRST_LINE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_FIRST_LINE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_FIRST_LINE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][skip_first_line]', '', $this->template->getValue('skip_first_line', 'general', 0)); ?>
				</td>
			</tr>
			<!-- Overwrite existing data -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_OVERWRITE_EXISTING_DATA_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_OVERWRITE_EXISTING_DATA_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_OVERWRITE_EXISTING_DATA_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][overwrite_existing_data]', '', $this->template->getValue('overwrite_existing_data', 'general', 1)); ?>
				</td>
			</tr>
			<!-- Ignore non-existent data -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IGNORE_NON_DATA_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IGNORE_NON_DATA_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IGNORE_NON_DATA_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][ignore_non_exist]', '', $this->template->getValue('ignore_non_exist', 'general', 0)); ?>
				</td>
			</tr>
			<!-- Skip default value -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_DEFAULT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_DEFAULT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_SKIP_DEFAULT_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][skip_default_value]', '', $this->template->getValue('skip_default_value', 'general', 0)); ?>
				</td>
			</tr>

			<!-- Show preview -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_SHOW_PREVIEW_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_SHOW_PREVIEW_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_SHOW_PREVIEW_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][show_preview]', '', $this->template->getValue('show_preview', 'general', 0)); ?>
					<input type="hidden" id="do_preview" name="do_preview" value="<?php echo $this->template->getValue('show_preview', 'general', 0); ?>" />
				</td>
			</tr>

			<!-- Collect debug info -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][collect_debug_info]', '', $this->template->getValue('collect_debug_info', 'general', 0)); ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_XML_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Refresh XML headers for every record -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_REFRESH_XML_HEADERS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_REFRESH_XML_HEADERS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_REFRESH_XML_HEADERS_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][refresh_xml_headers]', '', $this->template->getValue('refresh_xml_headers', 'general', 0)); ?>
				</td>
			</tr>
			<!-- XML Record Nodes -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_XML_NODES_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_XML_NODES_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_XML_NODES_LABEL'); ?></span>
				</td>
				<td>
					<textarea id='xml_nodes_map' name='jform[general][xml_nodes_map]' rows="25" cols="100"><?php echo $this->template->getValue('xml_nodes_map', 'general', '<item />', 'string', JREQUEST_ALLOWRAW);?></textarea>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<script type="text/javascript">
jQuery(document).ready(function() {
	if (<?php echo $this->template->getValue('auto_detect_delimiters', 'general', 1); ?> == '1') {
		jQuery('#field_delimiter').attr("disabled", true);
		jQuery('#text_enclosure').attr("disabled", true);
	}
});
jQuery('#jform\\[general\\]\\[auto_detect_delimiters\\]0').live('click', function() {
	jQuery('#field_delimiter').attr("disabled", false);
	jQuery('#text_enclosure').attr("disabled", false);
});

jQuery('#jform\\[general\\]\\[auto_detect_delimiters\\]1').live('click', function() {
	jQuery('#field_delimiter').attr("disabled", true);
	jQuery('#text_enclosure').attr("disabled", true);
});

jQuery('#jform\\[general\\]\\[use_column_headers\\]1').live('click', function() {
	jQuery('#jform\\[general\\]\\[skip_first_line\\]0').attr("checked", true);
});

jQuery('#jform\\[general\\]\\[use_column_headers\\]0').live('click', function() {
	jQuery('#jform\\[general\\]\\[refresh_xml_headers\\]0').attr("checked", true);
});

jQuery('#jform\\[general\\]\\[refresh_xml_headers\\]1').live('click', function() {
	jQuery('#jform\\[general\\]\\[use_column_headers\\]1').attr("checked", true);
	jQuery('#jform\\[general\\]\\[skip_first_line\\]0').attr("checked", true);
});

jQuery('#jform\\[general\\]\\[skip_first_line\\]1').live('click', function() {
	jQuery('#jform\\[general\\]\\[use_column_headers\\]0').attr("checked", true);
	jQuery('#jform\\[general\\]\\[refresh_xml_headers\\]0').attr("checked", true);
});
jQuery('#jform\\[general\\]\\[show_preview\\]0').live('click', function() {
	jQuery('#do_preview').val('0');
});
jQuery('#jform\\[general\\]\\[show_preview\\]1').live('click', function() {
	jQuery('#do_preview').val('1');
});
</script>