<?php
/**
 * Export taxes
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_tax.php 1551 2011-03-16 08:51:20Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' ); 
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TAX_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Country filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_COUNTRY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_COUNTRY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_COUNTRY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['tax_country']; ?>
				</td>
			</tr>
			<!-- State filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_LABEL'); ?></span>
				</td>
				<td id="taxstates">
					<?php echo $this->lists['tax_state']; ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<script type="text/javascript">
jQuery('#jformtaxcountries').live('change', function() {
	var country = jQuery('#jformtaxcountries').val();
	if (country == 'none') {
		jQuery('#jformtaxstates option').each(function(state){
			if (jQuery(this).val() !== '') jQuery(this).remove();
		});
	}
	else {
		jQuery.ajax({
				async: false,
				url: 'index.php',
				dataType: 'json',
				data: 'option=com_csvivirtuemart&view=export&task=getstates&format=json&country='+country,
				success: function(data) {
					jQuery('#taxstates').html(data);
				},
				error:function (xhr, ajaxOptions, thrownError){
					jAlert(thrownError);
				}  
		});
	}
});
</script>