<?php
/**
 * Export products
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_product.php 1623 2011-09-28 17:39:57Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- SEF URL -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SEF_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SEF_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SEF_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][exportsef]', '', $this->template->getValue('exportsef', 'product', 1)); ?>
				</td>
			</tr>
			<!-- Product URL suffix -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_URL_SUFFIX_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_URL_SUFFIX_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_URL_SUFFIX_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" id="producturl_suffix" name="jform[product][producturl_suffix]" value="<?php echo $this->template->getValue('producturl_suffix', 'product'); ?>" />
				</td>
			</tr>
			<!-- Featured filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_FEATURED_FILTER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_FEATURED_FILTER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_FEATURED_FILTER_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][featured]', '', $this->template->getValue('featured', 'product')); ?>
				</td>
			</tr>
			<!-- JoomFish translation -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_TRANSLATION_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_TRANSLATION_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_TRANSLATION_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][use_joomfish]', '', $this->template->getValue('use_joomfish', 'product')); ?>
				</td>
			</tr>
			<!-- JoomFish languages -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_LANGUAGE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_LANGUAGE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_JOOMFISH_LANGUAGE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['joomfish_language']; ?>
				</td>
			</tr>
			<!-- Product categories -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CATEGORY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CATEGORY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CATEGORY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['product_categories']; ?>
				</td>
			</tr>
			<!-- Check which state the category must have -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CATEGORY_STATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CATEGORY_STATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CATEGORY_STATE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['publish_state_categories']; ?>
				</td>
			</tr>
			<!-- Product selection categories -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_INCLUDE_SUBCATEGORY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_INCLUDE_SUBCATEGORY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_INCLUDE_SUBCATEGORY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][incl_subcategory]', '', $this->template->getValue('incl_subcategory', 'product')); ?>
				</td>
			</tr>
			<!-- Parent products only -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PARENT_ONLY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PARENT_ONLY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PARENT_ONLY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][parent_only]', '', $this->template->getValue('parent_only', 'product')); ?>
				</td>
			</tr>
			<!-- Child products only -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CHILD_ONLY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CHILD_ONLY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CHILD_ONLY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][child_only]', '', $this->template->getValue('child_only', 'product')); ?>
				</td>
			</tr>
			<!-- SKU filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SKU_FILTER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SKU_FILTER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SKU_FILTER_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" class="longtext" name="jform[product][productskufilter]" id="productskufilter" value="<?php echo $this->template->getValue('productskufilter', 'product'); ?>" />

				</td>
			</tr>
			<!-- Price filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['priceoperators']; ?>
					<input type="text" name="jform[product][pricefrom]" id="pricefrom" value="<?php echo $this->template->getValue('pricefrom', 'product'); ?>" /> - <input type="text" name="jform[product][priceto]" id="priceto" value="<?php echo $this->template->getValue('priceto', 'product'); ?>" />
				</td>
			</tr>
			<!-- Price Quantity Start filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_START_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_START_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_START_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[product][pricequantitystartfrom]" id="pricequantitystartfrom" value="<?php echo $this->template->getValue('pricequantitystartfrom', 'product'); ?>" /> - <input type="text" name="jform[product][pricequantitystartto]" id="pricequantitystartto" value="<?php echo $this->template->getValue('pricequantitystartto', 'product'); ?>" />
				</td>
			</tr>
			<!-- Price Quantity End filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_END_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_END_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_PRICE_QUANTITY_END_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[product][pricequantityendfrom]" id="pricequantityendfrom" value="<?php echo $this->template->getValue('pricequantityendfrom', 'product'); ?>" /> - <input type="text" name="jform[product][pricequantityendto]" id="pricequantityendto" value="<?php echo $this->template->getValue('pricequantityendto', 'product'); ?>" />
				</td>
			</tr>
			<!-- Stock level -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_STOCK_LEVEL_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_STOCK_LEVEL_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_STOCK_LEVEL_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[product][stocklevelstart]" id="stocklevelstart" value="<?php echo $this->template->getValue('stocklevelstart', 'product'); ?>" /> - <input type="text" name="jform[product][stocklevelend]" id="stocklevelend" value="<?php echo $this->template->getValue('stocklevelend', 'product'); ?>" />
				</td>
			</tr>
			<!-- Cdate filter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CDATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CDATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_CDATE_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[product][cdatefrom]" id="cdatefrom" value="<?php echo $this->template->getValue('cdatefrom', 'product'); ?>" /> - <input type="text" name="jform[product][cdateend]" id="cdateend" value="<?php echo $this->template->getValue('cdateend', 'product'); ?>" />
				</td>
			</tr>
			<!-- Currency info -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CURRENCY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CURRENCY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_CURRENCY_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['targetcurrency']; ?>
				</td>
			</tr>

			<!-- Set shopper group name the user wants to export -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SHOPPER_GROUP_NAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SHOPPER_GROUP_NAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SHOPPER_GROUP_NAME_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['shopper_groups']; ?>
				</td>
			</tr>

			<!-- Set manufacturer name the user wants to export -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['manufacturers']; ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>