<?php
/**
 * Export order items
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_orderitem.php 1517 2011-02-27 07:00:37Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
		<!-- Order numbers -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_NUMBER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_NUMBER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_NUMBER_LABEL'); ?></span>
			</td>
			<td>
				<input type="text" name="jform[orderitem][orderitemsnostart]" id="orderitemnostart" value="<?php echo $this->template->getValue('orderitemsnostart', 'orderitem'); ?>" /> - <input type="text" name="jform[orderitem][orderitemsnoend]" id="orderitemnoend" value="<?php echo $this->template->getValue('orderitemsnoend', 'orderitem'); ?>" />
			</td>
		</tr>
		<!-- List of order numbers -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_LABEL'); ?></span>
			</td>
			<td>
				<input class="longtext" type="text" name="jform[orderitem][orderitemlist]" id="orderlist" value="<?php echo $this->template->getValue('orderitemlist', 'orderitem'); ?>" />
			</td>
		</tr>
		<!-- Order date -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_DATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_DATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_DATE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('calendar', $this->template->getValue('orderitemsdatestart', 'orderitem'), 'jform[orderitem][orderitemsdatestart]', 'orderitemsdatestart', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
				 - 
				<?php echo JHTML::_('calendar', $this->template->getValue('orderitemsdateend', 'orderitem'), 'jform[orderitem][orderitemsdateend]', 'orderitemsdateend', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
			</td>
		</tr>
		<!-- Order modified date -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_MODIFIED_DATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_MODIFIED_DATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_MODIFIED_DATE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('calendar', $this->template->getValue('orderitemsmdatestart', 'orderitem'), 'jform[orderitem][orderitemsmdatestart]', 'orderitemsmdatestart', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
				 - 
				<?php echo JHTML::_('calendar', $this->template->getValue('orderitemsmdateend', 'orderitem'), 'jform[orderitem][orderitemsmdateend]', 'orderitemsmdateend', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
			</td>
		</tr>
		<!-- Order status -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_STATUS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_STATUS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_STATUS_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['orderitemstatus']; ?>
			</td>
		</tr>
		<!-- Order currency -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_CURRENCY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_CURRENCY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_CURRENCY_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['orderitemcurrency']; ?>
			</td>
		</tr>
		<!-- Order price -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRICE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRICE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRICE_LABEL'); ?></span>
			</td>
			<td>
				<input type="text" name="jform[orderitem][orderitemspricestart]" id="orderitemspricestart" value="<?php echo $this->template->getValue('orderitemspricestart', 'orderitem'); ?>" /> - <input type="text" name="jform[orderitem][orderitemspriceend]" id="orderitemspriceend" value="<?php echo $this->template->getValue('orderitemspriceend', 'orderitem'); ?>" />
			</td>
		</tr>
		<!-- Order product -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRODUCT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRODUCT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEMS_PRODUCT_LABEL'); ?></span>
			</td>
			<td>
				<div id="searchitemproduct"><input type="text" name="searchitemproductbox" id="searchitemproductbox" value="" /></div>
				<table id="selectitemproductsku" class="adminlist">
					<thead>
					<tr><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SKU'); ?></th><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_NAME');?></th></tr>
					</thead>
				</table>
				<?php echo $this->lists['orderitemproduct']; ?>
			</td>
		</tr>
		</tbody>
	</table>
</fieldset>