<?php
/**
 * Export system limit options
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_limit.php 1517 2011-02-27 07:00:37Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LIMIT_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Use system limits -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[limit][use_system_limits]', '', $this->template->getValue('use_system_limits', 'limit')); ?>
				</td>
			</tr>
			<!-- Maximum execution time -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="max_execution_time" name="jform[limit][max_execution_time]" value="<?php echo $this->template->getValue('max_execution_time', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('max_execution_time')); ?>
				</td>
			</tr>
			<!-- Maximum memory -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="memory_limit" name="jform[limit][memory_limit]" value="<?php echo $this->template->getValue('memory_limit', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('memory_limit')); ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>