<?php
/**
 * Export general settings
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_general.php 1632 2011-10-03 08:33:10Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_DESTINATION_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Export to -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_DOWNLOAD_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_DOWNLOAD_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_DOWNLOAD_LABEL'); ?></span>
				</td>
				<td>
					<?php $checked = ($this->template->getValue('exportto', 'general') == 'todownload' || $this->template->getValue('exportto', 'general', false) == false) ? 'checked="checked"' : ''; ?>
					<input type="radio" name="jform[general][exportto]" id="todownload" value="todownload" <?php echo $checked; ?> onClick="jQuery('.exportftp').hide(); jQuery('#exportlocation').hide();" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_LOCAL_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_LOCAL_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_LOCAL_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('exportto', 'general') == 'tofile') $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<input type="radio" name="jform[general][exportto]" id="tofile" value="tofile" <?php echo $checked; ?> onClick="jQuery('.exportftp').hide(); jQuery('#exportlocation').show();" />
				</td>
			</tr>
			<!-- Export location -->
			<tr id="exportlocation" <?php echo $showoption; ?> >
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LOCATION_INFO_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LOCATION_INFO_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LOCATION_INFO_LABEL'); ?></span>
				</td>
				<td>
					<?php $value = $this->template->getValue('localpath', 'general', JPath::clean(JPATH_ROOT, '/')."/media"); ?>
					<input type="text" size="120" name="jform[general][localpath]" value="<?php echo $value ?>" />
				</td>
			</tr>
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_FTP_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_FTP_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TO_FTP_LABEL'); ?></span>
				</td>
				<td>
					<?php
						$checked = '';
						$showoption = '';
						if ($this->template->getValue('exportto', 'general') == 'toftp') $checked = 'checked="checked"';
						else $showoption = 'style="display: none;"';
					?>
					<input type="radio" name="jform[general][exportto]" id="toftp" value="toftp" <?php echo $checked; ?> onClick="jQuery('#exportlocation').hide(); jQuery('.exportftp').show();" />
				</td>
			</tr>

			<!-- Export FTP -->
			<!-- FTP Host -->
			<tr class="exportftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_HOST_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftphost]" value="<?php echo $this->template->getValue('ftphost', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Port -->
			<tr class="exportftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PORT_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" name="jform[general][ftpport]" value="<?php echo $this->template->getValue('ftpport', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Username -->
			<tr class="exportftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_USERNAME_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftpusername]" value="<?php echo $this->template->getValue('ftpusername', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Password -->
			<tr class="exportftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_PASS_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="password" name="jform[general][ftppass]" value="<?php echo $this->template->getValue('ftppass', 'general'); ?>" />
				</td>
			</tr>
			<!-- FTP Root -->
			<tr class="exportftp" <?php echo $showoption; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FTP_ROOT_LABEL'); ?></span>
				</td>
				<td>
					<input class="longtext" type="text" name="jform[general][ftproot]" value="<?php echo $this->template->getValue('ftproot', 'general'); ?>" />
				</td>
			</tr>
			<!-- E-mail exported file -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_EMAIL_FILE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_EMAIL_FILE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_EMAIL_FILE_LABEL'); ?></span>
				</td>
				<td>
					<?php $checked = ($this->template->getValue('exportto', 'general') == 'toemail') ? 'checked="checked"' : ''; ?>
					<input type="radio" name="jform[general][exportto]" id="toemail" value="toemail" <?php echo $checked; ?> onClick="jQuery('.exportftp').hide(); jQuery('#exportlocation').hide();" />
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILE_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Export filename -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILENAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILENAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILENAME_LABEL'); ?></span>
				</td>
				<td><input class="longtext" type="text" id="export_filename" name="jform[general][export_filename]" value="<?php echo $this->template->getValue('export_filename', 'general'); ?>" /></td>
			</tr>
			<!-- Export type -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['export_file'] ?>
				</td>
			</tr>
			<!-- Export site -->
			<?php
				$export_file = $this->template->getValue('export_file', 'general', 'csv');
				$display = ($export_file == 'xml' || $export_file == 'html') ? '' : 'style="display: none;"'; ?>
			<tr id="div_export_site" <?php echo $display; ?>>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SITE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SITE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SITE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['export_site'] ?>
				</td>
			</tr>
			<!-- Field delimiter -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_DELIMITER_LABEL'); ?></span>
				</td>
				<td>
					<input class="delimiter" type="text" maxlength="1" id="field_delimiter" name="jform[general][field_delimiter]" value="<?php echo $this->template->getValue('field_delimiter', 'general', ','); ?>">
				</td>
			</tr>
			<!-- Text enclosure -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_TEXT_ENCLOSURE_LABEL'); ?></span>
				<td>
				<input class="delimiter" type="text" maxlength="1" id="text_enclosure" name="jform[general][text_enclosure]"
					<?php
						if ($this->template->getValue('text_enclosure', 'general', '') == '"') echo "value='".$this->template->getValue('text_enclosure', 'general', '')."'";
						else echo 'value="'.$this->template->getValue('text_enclosure', 'general').'"';
					?>
					/>
				</td>
			</tr>
			<!-- Category separator -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_CATEGORY_SEPARATOR_LABEL'); ?></span>
				<td>
				<input class="delimiter" type="text" id="category_separator" name="jform[general][category_separator]" value="<?php echo $this->template->getValue('category_separator', 'general', '/'); ?>" />
				</td>
			</tr>
			<!-- Include column headers -->
			<tr id="div_include_column_headers">
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_INCLUDE_COLUMN_HEADERS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_INCLUDE_COLUMN_HEADERS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_INCLUDE_COLUMN_HEADERS_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][include_column_headers]', '', $this->template->getValue('include_column_headers', 'general', 1)); ?>
				</td>
			</tr>
			<!-- BOM Signature -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SIGNATURE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SIGNATURE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SIGNATURE_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][signature]', '', $this->template->getValue('signature', 'general')); ?>
				</td>
			</tr>
			<!-- Export frontend -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FRONTEND_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FRONTEND_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FRONTEND_LABEL'); ?></span>
				</td>
				<td><?php echo $this->lists['export_frontend']; ?></td>
			</tr>
			<!-- Collect debug info -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_COLLECT_DEBUG_INFO_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[general][collect_debug_info]', '', $this->template->getValue('collect_debug_info', 'general', 0)); ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FILTER_OPTIONS'); ?></legend>
	<table class="admintable">
		<!-- Check which state the user want to export -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_STATE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['publish_state']; ?>
			</td>
		</tr>
		<!-- Number of records -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_NUMBER_RECORDS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_NUMBER_RECORDS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_NUMBER_RECORDS_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_NUMBER_RECORDS'); ?> <input type="text" name="jform[general][recordstart]" id="recordstart" value="<?php echo $this->template->getValue('recordstart', 'general'); ?>" />
				<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_START_RECORD'); ?> <input type="text" name="jform[general][recordend]" id="recordend" value="<?php echo $this->template->getValue('recordend', 'general'); ?>" />
			</td>
		</tr>
		<!-- Record grouping -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_GROUPBY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_GROUPBY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_GROUPBY_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('select.booleanlist', 'jform[general][groupby]', '', $this->template->getValue('groupby', 'general', '1')); ?>
			</td>
		</tr>
		<!-- VirtueMart ID -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_VM_ID_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_VM_ID_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_VM_ID_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['vm_itemid']; ?>
			</td>
		</tr>
	</table>
</fieldset>

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FORMAT_OPTIONS'); ?></legend>
	<table class="admintable">
		<!-- Date format -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_DATE_FORMAT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_DATE_FORMAT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_DATE_FORMAT_LABEL'); ?></span>
			</td>
			<td>
				<input type="text" id="export_date_format" name="jform[general][export_date_format]" value="<?php echo $this->template->getValue('export_date_format', 'general', 'd/m/Y H:i:s'); ?>" />
			</td>
		</tr>
		<!-- Price format -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRICE_FORMAT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRICE_FORMAT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRICE_FORMAT_LABEL'); ?></span>
			</td>
			<td>
				<table>
				<tr><td><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FORMAT_DECIMAL') ?></td><td><input class="delimiter" maxlength="1" type="text" id="export_price_format_decimal" name="jform[general][export_price_format_decimal]" value="<?php echo $this->template->getValue('export_price_format_decimal', 'general', 2, 'int'); ?>" /></td></tr>
				<tr><td><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FORMAT_DECIMAL_SEPARATOR') ?></td><td><input class="delimiter" maxlength="1" type="text" id="export_price_format_decsep" name="jform[general][export_price_format_decsep]" value="<?php echo $this->template->getValue('export_price_format_decsep', 'general'); ?>" /></td></tr>
				<tr><td><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_FORMAT_THOUSAND_SEPERATOR') ?></td><td><input class="delimiter" maxlength="1" type="text" id="export_price_format_thousep" name="jform[general][export_price_format_thousep]" value="<?php echo $this->template->getValue('export_price_format_thousep', 'general'); ?>" /></td></tr>
				</table>
			</td>
		</tr>
		<!-- Add currency to price -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ADD_CURRENCY_TO_PRICE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ADD_CURRENCY_TO_PRICE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ADD_CURRENCY_TO_PRICE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['add_currency_to_price']; ?>
			</td>
		</tr>
	</table>
</fieldset>
<script type="text/javascript">
jQuery("#jformgeneralexport_file").live('change', function() {
	var site = jQuery(this).val();
	switch (site) {
		case 'xml':
		case 'html':
			jQuery.ajax({
				async: false,
				url: 'index.php',
				dataType: 'json',
				data: 'option=com_csvivirtuemart&view=export&task=loadsites&format=json&exportsite='+site,
				success: function(data) {
					if (data) {
						jQuery('#jformgeneralexport_site').parent().html(data);
					}
				},
				failure: function() {
					jQuery('#jformgeneralexport_site').html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_LOADING_SITES'); ?>');
				},
				error: function() {
					jQuery('#jformgeneralexport_site').html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_LOADING_SITES'); ?>');
				}
			});
			jQuery('#div_export_site').show();
			break;
		default:
			jQuery('#div_export_site').hide();
			break;
	}
})
</script>