<?php
/**
 * VMF features table
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: custom_table.php 1543 2011-03-08 08:49:57Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVmf_features extends JTable {

	// Sets whether the database columns have been loaded
	private $_loaded = false;

	/**
	 * Method Description
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param 		$db	object	A database connector object
	 * @return
	 * @since 		3.0
	 */
	public function __construct($db) {
		$this->reset();
		parent::__construct('#__vmfilteringcat', 'id', $db);
	}

	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}

	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}

	/**
	 * Resets the default properties
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		void
	 * @since 		3.5
	 */
	public function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vmfilteringcat'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}

	/**
	 * Check if the feature already exists
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		bool	true if feature exists | false if feature does not exist
	 * @since 		3.5
	 */
	public function check() {
		$q = "SELECT ".$this->_tbl_key.
			" FROM ".$this->_tbl.
			" WHERE ".$this->_db->nameQuote('name')." = ".$this->_db->Quote($this->name);
		$this->_db->setQuery($q);
		$id = $this->_db->loadResult();
		if ($id) {
			$this->setValue('id', $id);
			return true;
		}
		else return false;
	}

	/**
	 * Get the feature ID based on name
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		int	the feature ID
	 * @since 		3.5
	 */
	public function getCategoryId($name) {
		$q = "SELECT ".$this->_tbl_key.
			" FROM ".$this->_tbl.
			" WHERE ".$this->_db->nameQuote('name')." = ".$this->_db->Quote($name);
		$this->_db->setQuery($q);
		return $this->_db->loadResult();
	}
}
?>