<?php
/**
 * Templates model
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: templates.php 1526 2011-03-04 15:34:04Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Templates Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelTemplates extends JModel {
	
	/**
	 * Get the saved templates 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		string	$kind	the kind of templates to load import/export
	 * @return 		array	list of template objects
	 * @since 		3.0
	 */
	public function getTemplates($kind) {
		$db = JFactory::getDBO();
		$q = "SELECT name AS text, id AS value
			FROM #__csvivirtuemart_template_settings
			WHERE `type` = ".$db->Quote($kind)."
			ORDER BY name";
		$db->setQuery($q);
		$templates = $db->loadObjectList();
		if (!is_array($templates)) $templates = array();
		$new = array();
		$new[] = JHtml::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_SAVE_AS_NEW_FOR_NEW_TEMPLATE'));
		$templates = array_merge($new, $templates);
		return $templates;
	}
	
	/**
	 * Get the selected template 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		array	list of template objects
	 * @since 		3.0
	 */
	public function getTemplate() {
		$settings = array();
		$template_id = JRequest::getInt('template_id', 0);
		if ($template_id > 0) {
			$db = JFactory::getDBO();
			$q = "SELECT settings
				FROM #__csvivirtuemart_template_settings
				WHERE id = ".$template_id;
			$db->setQuery($q);
			$settings = json_decode($db->loadResult(), true);
		}
		return $settings;
	}
	
	/**
	 * Save export settings 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		array	$data	the data to be stored
	 * @return 		bool	true on success | false on failure
	 * @since 		3.0
	 */
	public function save($data, $type) {
		$app = JFactory::getApplication();
		$table = $this->getTable('csvivirtuemart_template_settings');
		$bind = array();
		$id = JRequest::getInt('template_id', 0);
		if ($id > 0) $table->load($id);
		else $bind['name'] = JRequest::getVar('template_name', 'Template '.time());
		$bind['settings'] = json_encode($data);
		$bind['type'] = $type;
		$table->bind($bind);
		if ($table->store()) {
			$app->enqueueMessage(JText::sprintf('COM_CSVIVIRTUEMART_'.strtoupper($type).'_SETTINGS_SAVED', $table->name));
		}
		else {
			$app->enqueueMessage(JText::sprintf('COM_CSVIVIRTUEMART_'.strtoupper($type).'_SETTINGS_NOT_SAVED', $table->getError()), 'error');
		}
		return $table->id;
	}
	
	/**
	 * Remove a settings template 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		array	$data	the data to be stored
	 * @return 		bool	true on success | false on failure
	 * @since 		3.0
	 */
	public function remove($type) {
		$app = JFactory::getApplication();
		$table = $this->getTable('csvivirtuemart_template_settings');
		$table->load(JRequest::getInt('template_id', null, 'post'));
		if ($table->delete()) {
			$app->enqueueMessage(JText::sprintf('COM_CSVIVIRTUEMART_'.strtoupper($type).'_SETTINGS_DELETED', $table->name));
		}
		else {
			$app->enqueueMessage(JText::sprintf('COM_CSVIVIRTUEMART_'.strtoupper($type).'_SETTINGS_NOT_DELETED', $table->getError()), 'error');
		}
	}
	
		/**
	* Get the template details
	*
	* Retrieves the template details from the csvi_templates table. If the
	* template id is 0, it will automatically retrieve the template details
	* for the template with the lowest ID in the database
	*
	* @see self::GetFirstTemplateId();
	* @param $templateid integer Template ID to retrieve
	*/
	public function _getTemplate() {
		$row = $this->getTable($this->_tablename);
		if ($this->_id == 0) {
			$this_id = $this->GetFirstTemplateId();
		}
		$row->load($this->_id);
		
		// Fix the price format
		$row->export_price_formats = self::getNumberFormat($row->export_price_format);
		return $row;
	}
	
	/**
	 * Load the template types based on type 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		string	$type	The type of template to filter on
	 * @return 		array	list of template types
	 * @since 		3.0
	 */
	function getTemplateTypes($type=false) {
		$db = JFactory::getDBO();
		$q = "SELECT CONCAT('COM_CSVIVIRTUEMART_', UPPER(template_type_name)) AS name, template_type_name AS value 
			FROM #__csvivirtuemart_template_types ";
		$q .= ($type) ? "WHERE template_type = ".$db->Quote($type) : "";
		$q .= " ORDER BY template_type_name";
		$db->setQuery($q);
		$types = $db->loadObjectList();
		
		// Translate the strings
		foreach ($types as $key => $type) {
			$type->value = JText::_($type->value);
			$types[$key] = $type;
		}
		return $types;
	}
}
?>