<?php
/**
 * Log details model
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: logdetails.php 1551 2011-03-16 08:51:20Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Log details Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelLogdetails extends JModel {
	
	/**
	* Items total
	* @var integer
	*/
	var $_total = null;
	
	/**
	* Pagination object
	* @var object
	*/
	var $_pagination = null;
	
	/**
	* Constructor 
	* 
	* @author RolandD
	* @access public
	*/
	public function __construct() {
		parent::__construct();
		
		$mainframe = JFactory::getApplication();
		$option	= JRequest::getCmd('option');
		
		// Get pagination request variables           
		$limit 				= $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		$limitstart 		= JRequest::getVar('limitstart', 0, '', 'int');
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit)* $limit) : 0);
		
		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
	}
	
	function getData() {
        // if data hasn't already been obtained, load it
        if (empty($this->_data)) {
            $query = $this->_buildQuery();
            $this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_data;
    }
    
    public function getTotal() {
        // Load the content if it doesn't already exist
        if (empty($this->_total)) {
            $query = $this->_buildQuery();
            $this->_total = $this->_getListCount($query);
        }
        return $this->_total;
    }
    
    function getPagination() {
        // Load the content if it doesn't already exist
        if (empty($this->_pagination)) {
            jimport('joomla.html.pagination');
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
        }
        return $this->_pagination;
    }
	
	/**
	 * Create the query to retrieve available fields 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	private function _buildQuery() {
		$mainframe = Jfactory::getApplication();
		$db = JFactory::getDBO();
		
		$run_id = JRequest::getInt('run_id', false);
		if (!$run_id) {
			// Try to get it from the cid
			$cids = JRequest::getVar('cid');
			if (is_array($cids) && array_key_exists('0', $cids)) $filter = $cids[0];
			else $filter = false;
		}
		else $filter = $run_id;
		
		// Load filters
		$filter_action = JRequest::getVar('filter_action', false);
		$filter_result = JRequest::getVar('filter_result', false);
		$filter_order		= $mainframe->getUserStateFromRequest('logdetails.filter_order',		'filter_order',		'line',	'cmd');
		if ($filter_order == '') $filter_order = 'line';
		$filter_order_Dir	= $mainframe->getUserStateFromRequest('logdetails.filter_order_Dir',	'filter_order_Dir',	'asc',	'word');
		if ($filter_order_Dir == '') $filter_order_Dir = 'asc';
		$filter_state		= $mainframe->getUserStateFromRequest('logdetails.filter_state',		'filter_state',		'',	'word');
		$filters = array();
		
		// Start query
		$q = "SELECT line, description, status, log_id, result FROM ".$db->nameQuote('#__csvivirtuemart_log_details')." AS d ";
		
		// Add filters
		if ($filter) {
			$filters[] = 'log_id IN (SELECT id FROM #__csvivirtuemart_logs WHERE run_id = '.$filter.')';
		}
		if ($filter_action) $filters[] = $db->nameQuote('status').' = '.$db->Quote($filter_action);
		if ($filter_result) $filters[] = $db->nameQuote('result').' = '.$db->Quote($filter_result);
		
		if (count($filters) > 0) $q .= " WHERE ".implode(' AND ', $filters);
		if ($filter_order) $q .= " ORDER BY ".$filter_order.' '.$filter_order_Dir;
		
		return $q;
	}
	
	/**
	 * Get the actions available for the current log 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		array	of available actions
	 * @since 		3.0
	 */
	public function getActions() {
		$db = JFactory::getDBO();
		$run_id = JRequest::getInt('run_id');
		$q = "SELECT CONCAT('COM_CSVIVIRTUEMART_', UPPER(".$db->nameQuote('status').")) AS ".$db->Quote('text').", ".$db->nameQuote('status')." as ".$db->Quote('value')."
			FROM ".$db->nameQuote('#__csvivirtuemart_log_details')."
			WHERE log_id IN (SELECT id FROM #__csvivirtuemart_logs WHERE run_id = ".$run_id.")
			GROUP by ".$db->nameQuote('value');
		$db->setQuery($q);
		return $db->loadObjectList();
	}
	
	/**
	 * Get the results available for the current log 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		array	of available results
	 * @since 		3.0
	 */
	public function getResults() {
		$db = JFactory::getDBO();
		$run_id = JRequest::getInt('run_id');
		$q = "SELECT CONCAT('COM_CSVIVIRTUEMART_', UPPER(".$db->nameQuote('result').")) AS ".$db->Quote('text').", ".$db->nameQuote('result')." as ".$db->Quote('value')."
			FROM ".$db->nameQuote('#__csvivirtuemart_log_details')."
			WHERE log_id IN (SELECT id FROM #__csvivirtuemart_logs WHERE run_id = ".$run_id.")
			GROUP by ".$db->nameQuote('result');
		$db->setQuery($q);
		return $db->loadObjectList();
	}
}
?>