<?php
/**
 * Waitinglist import
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: waitinglistimport.php 1593 2011-05-25 12:30:12Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Main processor for importing waitinglists
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelWaitinglistimport extends CsvivirtuemartModelImportfile {
	
	// Private tables
	/** @var object contains the vm_waiting_list table */
	private $_vm_waiting_list = null;
	
	// Public variables
	/** @var integer contains the waiting list ID for an entry */
	public $waiting_list_id = null;
	public $product_id = null;
	public $user_id = null;
	public $username = false;
	
	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }
    
	/**
	 * Here starts the processing 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();
		
		// Get the logger
		$csvilog = JRequest::getVar('csvilog');
		
		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;
					
					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}
	
	/**
	 * Process each record and store it in the database 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');
		
		// Get the product ID
		if (empty($this->product_id)) $this->product_id = $this->getProductId();
		
		// Get the user ID
		if (empty($this->user_id)) $this->user_id = $this->_getUserId();
		
		if ($this->product_id && $this->user_id && $this->notify_email) {
			// Bind the data
			$this->_vm_waiting_list->bind($this);
			
			// Check the data
			$this->_vm_waiting_list->check();
			
			// Store the data
			if ($this->_vm_waiting_list->store()) {
				if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_WAITINGLIST'));
				else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_WAITINGLIST'));
			}		
			else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_WAITINGLIST_NOT_ADDED', $this->_vm_waiting_list->getError()));
			
			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_WAITINGLIST_QUERY'), true);
		}
		else {
			 $csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_WAITINGLIST_NO_USER_PRODUCT_ID'));
		}
		
		// Clean the tables
		$this->cleanTables();
	}
	
	/**
	 * Load the waiting list related tables 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.01
	 */
	private function _loadTables() {
		$this->_vm_waiting_list = $this->getTable('vm_waiting_list');
	}
	
	/**
	 * Cleaning the waiting list related tables 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		protected
	 * @param 
	 * @return 
	 * @since 		3.1
	 */
	protected function cleanTables() {
		$this->_vm_waiting_list->reset();
		
		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
	
	/**
	 * Get the user ID 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 		mixed int when user ID found | false when not found
	 * @since 		3.1
	 */
	private function _getUserId() {
		if ($this->username) {
			$db = JFactory::getDBO();
			$csvilog = JRequest::getVar('csvilog');
			$q = "SELECT id
				FROM #__users
				WHERE username = ".$db->Quote($this->username);
			$db->setQuery($q);
			$result = $db->loadResult();
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_FIND_USER_ID'), true);
			if ($result) return $result;
			else return false;
		}
		else return false;
	}
}
?>