<?php
/**
 * VMF values import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: customimport.php 1556 2011-03-24 16:16:54Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for VMF values import
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelVmf_valuesimport extends CsvivirtuemartModelImportfile {

	// Private tables
	private $_vmf_values = null;
	private $_vmf_values_products = null;
	private $_vmf_features = null;

	// Public variables
	/** @var int the feature ID */
	public $vmf_cat = 0;
	/** @var int the value ID */
	public $ids = 0;
	/** @var int the product ID */
	public $product_id = 0;

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Get the product ID
		$this->product_id = $this->getProductId();

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		// Get the imported values
		$csvilog = JRequest::getVar('csvilog');

		// Process the feature
		$this->vmfCatId = $this->_vmf_features->getCategoryId($this->name);

		if ($this->vmfCatId) {
			// Bind the data
			$this->_vmf_values->bind($this);

			// Bind the value name
			if (isset($this->names)) $this->_vmf_values->setValue('nameS', $this->names);

			// Check the data
			$this->_vmf_values->check();

			// Store the data
			if ($this->_vmf_values->store()) {
				if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_VMF_VALUES'));
				else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_VMF_VALUES'));
				$this->ids = $this->_vmf_values->getValue('ids');
			}
			else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_VMF_VALUES_NOT_ADDED', $this->_vmf_values->getError()));

			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_VMF_VALUES_QUERY'), true);

			// See if there is a value ID
			if ($this->ids > 0 && $this->product_id > 0) {
				// Store the category relation
				$this->_vmf_values_products->bind($this);

				// Store the data
				if (!$this->_vmf_values_products->check()) {
					if ($this->_vmf_values_products->store()) {
						if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_VMF_VALUES_PRODUCTS'));
						else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_VMF_VALUES_PRODUCTS'));
					}
					else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_VMF_VALUES_PRODUCTS_NOT_ADDED', $this->_vmf_values_products->getError()));
				}

				// Store the debug message
				$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_VMF_VALUES_PRODUCTS_QUERY'), true);
			}
		}
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_VMF_VALUES_NO_FEATURE_ID', $this->name));

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the necessary tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vmf_values = $this->getTable('vmf_values');
		$this->_vmf_values_products = $this->getTable('vmf_values_products');
		$this->_vmf_features = $this->getTable('vmf_features');
	}

	/**
	 * Cleaning the tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vmf_values->reset();
		$this->_vmf_values_products->reset();
		$this->_vmf_features->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>