<?php
/**
 * Shipping rates import
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: shippingratesimport.php 1593 2011-05-25 12:30:12Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for shipping rates
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelShippingratesimport extends CsvivirtuemartModelImportfile {
	
	// Private tables
	/** @var object contains the vm_shipping_rate table */
	private $_vm_shipping_rates = null;
	
	// Public variables
	/** @var mixed contains the unique shipping rate id value */
	public $shipping_rate_id = null;
	
	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }
	
	/**
	 * Here starts the processing 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();
		
		// Get the logger
		$csvilog = JRequest::getVar('csvilog');
		
		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;
					
					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'shipping_rate_value':
							case 'shipping_rate_package_fee':
								$this->$name = $this->cleanPrice($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}
	
	/**
	 * Process each record and store it in the database 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		
		// Get the currency ID, the code takes preference over the name because it is less error prone
		if (isset($this->currency_code)) {
			$q = "SELECT currency_id FROM #__vm_currency WHERE currency_code = ".$db->Quote($this->currency_code);
			$db->setQuery($q);
			$this->shipping_rate_currency_id = $db->loadResult();
		}
		else if (isset($this->currency_name)) {
			$q = "SELECT currency_id FROM #__vm_currency WHERE currency_name = ".$db->Quote($this->currency_name);
			$db->setQuery($q);
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_FIND_SHIPPING_CURRENCY_ID'), true);
			$this->shipping_rate_currency_id = $db->loadResult();
		}
		
		// Bind the data
		$this->_vm_shipping_rate->bind($this);
		
		// Check the data
		$this->_vm_shipping_rate->check();
		
		// Store the data
		if ($this->_vm_shipping_rate->store()) {
			if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_SHIPPINGRATE'));
			else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_SHIPPINGRATE'));
		}		
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_SHIPPINGRATE_NOT_ADDED', $this->_vm_shipping_rate->getError()));
		
		// Store the debug message
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_SHIPPINGRATE_QUERY'), true);
		
		// Clean the tables
		$this->cleanTables();
	}
	
	/**
	 * Load the shipping rates related tables 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_shipping_rate = $this->getTable('vm_shipping_rate');
	}
	
	/**
	 * Cleaning the shipping rates related tables 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		protected
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_shipping_rate->reset();
		
		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>