<?php
/**
 * Multiple prices import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: multiplepricesimport.php 1593 2011-05-25 12:30:12Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for multiple prices
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelMultiplepricesimport extends CsvivirtuemartModelImportfile {

	// Private tables
	/** @var object contains the vm_manufacturer table */
	private $_vm_product_price = null;

	// Public variables
	/** @var integer contains the category ID for a product */
	public $category_id = null;
	/** @var integer contains the manufacturer category ID for a product */
	public $mf_category_id = null;
	/** @var integer contains the product ID for a price */
	public $product_id = null;
	/** @var integer contains the ID for a price */
	public $product_price_id = null;
	/** @var integer contains the value if the price needs to be deleted */
	public $price_delete = null;
	/** @var integer contains the id value of the shopper group */
	public $shopper_group_id = null;
	/** @var string contains the name value of the shopper group */
	public $shopper_group_name = null;
	/** @var int the price start value */
	public $price_quantity_start = 0;
	/** @var int the pice end value */
	public $price_quantity_end = 0;


	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'product_price':
								$this->$name = $this->cleanPrice($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}

	/**
	* Process each record and store it in the database
	*
	* @todo Add logging
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');

		// Get the product ID if we don't already have it
		if (!isset($this->product_id)) $this->product_id = $this->getProductId();

		/**
		 * Get the shopper group ID
		 *
		 * The shopper group ID takes preference over the shopper group name
		 */
		if (strlen(trim($this->shopper_group_id)) == 0) {
			if (strlen(trim($this->shopper_group_name)) > 0) {
				$this->shopper_group_id = $this->getShopperGroupName($this->shopper_group_name);
			}
			else $this->shopper_group_id = $this->getDefaultShopperGroupID();
		}

		// Check for empty shopper group ID
		if (!$this->product_price_id && empty($this->shopper_group_id)) {
			$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_SHOPPER_GROUP_FOUND'));
			return false;
		}

		// Currency check as we need a currency, take VM default currency if not set
		if (!isset($this->product_currency)) {
			$this->product_currency = $this->productCurrency(1);
		}

		// Bind the data
		$this->_vm_product_price->bind($this);

		// See if we need to find a product_price_id
		if (!isset($this->product_price_id)) {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_FIND_PRODUCT_PRICE_ID'));
			$this->_vm_product_price->checkMultiple();
			$this->product_price_id = $this->_vm_product_price->getValue('product_price_id');
		}
		else {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_ALREADY_HAVE_PRICE_ID'));
		}

		// Let's check for modified and creation dates
		if (empty($this->product_price_id)) {
			$this->_vm_product_price->setValue('mdate', time());
			$this->_vm_product_price->setValue('cdate', time());
		}
		else $this->_vm_product_price->setValue('mdate', time());

		// Check if the user wants to delete a price
		if (strtoupper($this->price_delete) == 'Y' && isset($this->product_price_id)) {
			if (!$this->_vm_product_price->delete($this->product_price_id)) {
				$csvilog->AddStats('deleted', JText::_('COM_CSVIVIRTUEMART_PRICE_NOT_DELETED'));
			}
			else {
				$csvilog->AddStats('deleted', JText::_('COM_CSVIVIRTUEMART_PRICE_DELETED'));
			}
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_TRIED_DELETE_PRICE'), true);
		}
		else {
			if (!isset($this->product_id)) {
				$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_ID_FOUND'));
				$csvilog->AddStats('skipped', JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_ID_FOUND'));
			}
			else if (!isset($this->product_price_id) && !isset($this->product_price)) {
				$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_PRICE_FOUND'));
				$csvilog->AddStats('skipped', JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_PRICE_FOUND'));
			}
			else {
				// See if there is any calculation needed on the prices
				if (isset($this->product_price_id)) $this->_vm_product_price->CalculatePrice();

				// Store the price
				if ($this->_vm_product_price->store()) {
					if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_MULTIPLE_PRICES'));
					else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_MULTIPLE_PRICES'));
				}
				else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_MULTIPLE_PRICES_NOT_ADDED', $this->_vm_product_price->getError()));

				// Store the debug message
				$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_MULTIPLE_PRICES_QUERY'), true);
			}
		}

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the multiple price related tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_product_price = $this->getTable('vm_product_price');
	}

	/**
	 * Cleaning the multiple price related tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_product_price->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>