<?php
/**
 * Coupons import
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: couponsimport.php 1593 2011-05-25 12:30:12Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for coupons
 *
 * Main processor for importing coupons
 *
 * @package CSVIVirtueMart
 * @todo 	Check vendor ID
 */
class CsvivirtuemartModelCouponsimport extends CsvivirtuemartModelImportfile {
	
	// Private tables
	/** @var object contains the vm_coupons table */
	private $_vm_coupons = null;
	
	// Public variables
	/** @var integer contains the coupon ID */
	public $coupon_id = null;
	
	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }
	
	/**
	 * Here starts the processing 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();
		
		// Get the logger
		$csvilog = JRequest::getVar('csvilog');
		
		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;
					
					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'coupon_value':
								$this->$name = $this->cleanPrice($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}
	
	/**
	 * Process each record and store it in the database 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');
		
		// Bind the data
		$this->_vm_coupons->bind($this);
		
		// Check the data
		$this->_vm_coupons->check();
		
		// Store the data
		if ($this->_vm_coupons->store()) {
			if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_COUPON'));
			else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_COUPON'));
		}		
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_COUPON_NOT_ADDED', $this->_vm_coupons->getError()));
		
		// Store the debug message
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_COUPON_QUERY'), true);
		
		// Clean the tables
		$this->cleanTables();
	}
	
	/**
	 * Load the coupon related tables 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_coupons = $this->getTable('vm_coupons');
	}
	
	/**
	 * Cleaning the coupon related tables 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		protected
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_coupons->reset();
		
		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>