<?php
/**
 * About model
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: about.php 1574 2011-04-16 15:00:03Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * About Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelAbout extends JModel {
	
	/**
	* Check folder permissions 
	* 
	* @author RolandD
	* @since 2.3.10
	* @access public 
	* @return array of folders and their permissions 
	*/
	public function getFolderCheck() {
		$config = JFactory::getConfig();
		$tmp_path = JPath::clean($config->getValue('config.tmp_path'), '/');
		$folders = array();
		$root = JPath::clean(JPATH_ROOT, '/');
		$folders[$tmp_path] = $this->_isWritable($tmp_path);
		$folders[CSVIPATH_TMP] = $this->_isWritable(CSVIPATH_TMP);
		$folders[CSVIPATH_DEBUG] = $this->_isWritable(CSVIPATH_DEBUG);
		$folders[$root.'/components/com_virtuemart/shop_image'] = $this->_isWritable($root.'/components/com_virtuemart/shop_image/');
		$folders[$root.'/components/com_virtuemart/shop_image/product'] = $this->_isWritable($root.'/components/com_virtuemart/shop_image/product/');
		$folders[$root.'/components/com_virtuemart/shop_image/product/resized'] = $this->_isWritable($root.'/components/com_virtuemart/shop_image/product/resized/');
		$folders[$root.'/components/com_virtuemart/shop_image/category'] = $this->_isWritable($root.'/components/com_virtuemart/shop_image/category/');
		$folders[$root.'/components/com_virtuemart/shop_image/category/resized'] = $this->_isWritable($root.'/components/com_virtuemart/shop_image/category/resized/');
		
		return $folders;
	}
	
	/**
	 * Check if a folder is writable 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param		string $path the path to check
	 * @return 		bool true if path is writable | false if path is not writable
	 * @since 		2.3.12
	 */
	private function _isWritable($path) {
		clearstatcache();
		if ($path{strlen($path)-1}=='/') // recursively return a temporary file path
			return $this->_isWritable($path.uniqid(mt_rand()).'.tmp');
		else if (is_dir($path))
			return $this->_isWritable($path.'/'.uniqid(mt_rand()).'.tmp');
		// check tmp file for read/write capabilities
		$rm = file_exists($path);
		$f = @fopen($path, 'a');
		if ($f===false)
			return false;
		fclose($f);
		if (!$rm)
			unlink($path);
		return true;
	}
	
	/**
	 * Check the latest version of CSVI VirtueMart 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		string	the status of the version check
	 * @since 		3.0
	 */
	public function getCheckVersion() {
		// Read the version file
		$cur_version = file_get_contents('http://www.csvimproved.com/csvivm.ver');
		$this_version = JText::_('COM_CSVIVIRTUEMART_CSVI_VERSION');
		if (version_compare($cur_version, $this_version) == '1') return JText::sprintf('COM_CSVIVIRTUEMART_NEW_VERSION_AVAILABLE', $this_version, $cur_version);
		else return JText::sprintf('COM_CSVIVIRTUEMART_VERSION_UPTODATE', $cur_version);
	}
	
	/**
	 * Create missing folders 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		
	 * @since 		3.0
	 */
	public function getCreateFolder() {
		$app = JFactory::getApplication();
		jimport('joomla.filesystem.folder');
		$folder = str_ireplace(JPATH_ROOT, '', JRequest::getVar('folder'));
		return JFolder::create($folder);
	}
}
?>