<?php
/**
 * Settings controller
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: settings.php 1522 2011-03-03 17:23:31Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.controller');

/**
 * Settings Controller
 *
 * @package    CSVIVirtueMart
 */
class CsvivirtuemartControllerSettings extends JController {
	
	/**
	* Method to display the view
	*
	* @access	public
	 */
	function __construct() {
		parent::__construct();
	}
	
	/**
	* Shows the logs
	*/
	public function Settings() {
		JRequest::setVar('view', 'settings');
		
		parent::display();
	}
	
	/**
	* Save the settings
	*/
	public function save() {
		$model = $this->getModel('settings');
		
		if ($model->getSaveSettings()) {
			$msg = JText::_('COM_CSVIVIRTUEMART_SETTINGS_SAVED_SUCCESSFULLY');
			$msgtype = '';
		}
		else {
			$msg = JText::_('COM_CSVIVIRTUEMART_SETTINGS_NOT_SAVED_SUCCESSFULLY');
			$msgtype = 'error';
		}
		$this->setRedirect('index.php?option=com_csvivirtuemart&view=settings', $msg, $msgtype);

	}
	
	/**
	 * Reset the settings
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.1.1
	 */
	public function reset() {
		$model = $this->getModel('settings');
		
		if ($model->getResetSettings()) {
			$msg = JText::_('COM_CSVIVIRTUEMART_SETTINGS_RESET_SUCCESSFULLY');
			$msgtype = '';
		}
		else {
			$msg = JText::_('COM_CSVIVIRTUEMART_SETTINGS_NOT_RESET_SUCCESSFULLY');
			$msgtype = 'error';
		}
		$this->setRedirect('index.php?option=com_csvivirtuemart&view=settings', $msg, $msgtype);
	}
}
?>