<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.error.log' );
jimport( 'joomla.application.component.view' );

class ViewCategories extends JView {
    
    public function display($tpl = null) {
        
        $model      =   $this->getModel();
        $layout     =   $this->getLayout();

        // Add styles
        $document       = JFactory::getDocument();
        $document->addStyleSheet( JURI::base() . 'components/com_vipquotes/vip_quotes.css', 'text/css', null, array( 'id' => 'VipQuotesStyleSheet' ) );
             
        // Get component parameters
        $app            =  JFactory::getApplication();
        $params         =  $app->getParams('com_vipquotes');
                
        $categories     =  $model->getCategories();
        $numOfColumns   =  $params->get("categoryColumns", 3);
        $categories     =  array_chunk($categories, $numOfColumns );
        
        $this->assign( 'numOfColumns',   $numOfColumns);
        $this->assignRef( 'params',      $params);
        $this->assignRef( "categories",  $categories );
        
        parent::display($tpl);
    }
    
    
}
?>