<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

/**
 * Method to build Route
 * @param array $query
 */ 
function VipQuotesBuildRoute( &$query ) {
	
	$segments	= array();
	unset($query["view"]);
	
	/**** Categories ****/
	if ( isset( $query["category_id"] ) ) { 
		
		static $categories = array();
		$categoryName = "";
		
		if ( empty( $categories ) ) {
			$db =& JFactory::getDBO();
			
			// prepare identifiers
			$tableIdentifier  = $db->nameQuote('#__vq_categories');
			$idIdentifier     = $db->nameQuote('id');
			$nameIdentifier   = $db->nameQuote('url');
			
			$sqlQuery = "
			  SELECT 
			      " . $tableIdentifier . "." .$idIdentifier   . ",
			      " . $tableIdentifier . "." .$nameIdentifier . "
		      FROM
		          " . $tableIdentifier;
	
			  $db->setQuery($sqlQuery);
			  $categories = $db->loadAssocList('id');
		}
		 
	   if ( isset( $categories[ $query["category_id"] ] ) ) {
          $categoryName = $categories[ $query["category_id"] ]['url'];
       }
		  
	   $segments[] = $categoryName;
       unset($query["category_id"]);
	}

	return $segments;
}

/**
 * Method to parse Route
 * @param array $segments
 */ 
function VipQuotesParseRoute( $segments ) {
	
	$query  = array();
	
	/**** Categories ****/
	if ( isset( $segments[0] ) ) {
		
		static $categories = array();
		
		if ( empty( $categories ) ) {
			     
	            $db =& JFactory::getDBO();
	            
	            // prepare identifiers
	            $tableIdentifier  = $db->nameQuote('#__vq_categories');
	            $idIdentifier     = $db->nameQuote('id');
	            $nameIdentifier   = $db->nameQuote('url');
	            
	            $sqlQuery = "
	              SELECT 
	                  " . $tableIdentifier . "." .$idIdentifier   . ",
	                  " . $tableIdentifier . "." .$nameIdentifier . "
	              FROM
	                  " . $tableIdentifier;
	    
	              $db->setQuery($sqlQuery);
	              $categories_ = $db->loadAssocList('id');
                  
                  foreach ( $categories_ as $category ) {
                        $categories[$category['id']] = $category['url'];
                  }
	              
	        }
	        
	   $alias      = array_pop($segments);
       $alias      = str_replace(":","-",$alias);
       
	   $categoryId = array_search($alias, $categories);
       
       if ( false === $categoryId ) {
            $categoryId = 0;
       }
            
       $query['category_id'] = intval( $categoryId );
       
	}
	
	return $query;
}
?>