<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

/**
 * HTML View class for the K2Store component
 *
 * @static
 * @package		Joomla
 * @subpackage	K2Store
 * @since 1.0
 */
class K2StoreViewOrders extends JView
{
	function display($tpl = null)
	{
		
		//initialise variables
		global $mainframe;

		$user		= &JFactory::getUser();
		$pathway	= &$mainframe->getPathway();
		$document	= & JFactory::getDocument();
		$model		= &$this->getModel();
		$option = 'com_k2store';
		//$limit		= $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
		//$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		
		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		//$limitstart	= $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );
		$limitstart	= (empty($_GET['limitstart'])) ? 0 : $mainframe->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 'int');
	
		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		
		// Get the parameters of the active menu item
		$menus	= &JSite::getMenu();
		$menu    = $menus->getActive();
		
			
		//get component params
		$params = &JComponentHelper::getParams('com_k2store');
	//	$limit = $params->get('OrdersCount', 5);
	//	JRequest::setVar('limit', $limit);
		 
		$options['limitstart'] = $limitstart;
		$options['limit'] = $limit;
		
 
		
		if(!$user->id) {
			$link = JRoute::_('index.php');
			$msg = JText::_('You should be logged in to view the orders');
			$mainframe->redirect($link, $msg);
			
		}
		 
		// get order data
		$orders	= $model->getOrders( $options );
	/*	
		if ($order[0]->user_id !== $user->id) {
			$link = JRoute::_('index.php');
			$msg = JText::_('Your orders alone can be viewed');
			$mainframe->redirect($link, $msg);
		}
		*/
		//print_r($orders); 
		
		
		jimport('joomla.html.pagination');
        $total = $model->getOrdersCount($options);
        $pagination = new JPagination($total, $limitstart, $limit);
				
		//set breadcrumbs
		if (isset( $menu ) && isset($menu->query['view']) && $menu->query['view'] != 'orders'){
			$pathway->addItem(JText::_('orders'), '');
		}
		
		$this->assignRef('orders',		$orders);
		$this->assignRef('pagination',		$pagination);
		$this->assignRef('params',		$params);
		
		parent::display($tpl);
	}
	
	

}
?>