<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

/**
 * HTML View class for the K2Store component
 *
 * @static
 * @package		Joomla
 * @subpackage	K2Store
 * @since 1.0
 */
class K2StoreViewOrder extends JView
{
	function display($tpl = null)
	{
		
		//initialise variables
		global $mainframe;
		$user 		=	& JFactory::getUser();
		$model		= &$this->getModel('orders');
		$pathway	= &$mainframe->getPathway();
		require_once(JPATH_COMPONENT.DS.'helpers'.DS.'icon.php');
		
			// Get the parameters of the active menu item
		$menus	= &JSite::getMenu();
		$menu    = $menus->getActive();
	
		//get component params
		$params = &JComponentHelper::getParams('com_k2store');

		
		if(!$user->id) {
			$link = JRoute::_('index.php');
			$msg = JText::_('You should be logged in to view the orders');
			$mainframe->redirect($link, $msg);
			
		}
		 
		// get order data
		$order	= & $this->get('Data');
		
		if ($order->user_id !== $user->id) {
			$link = JRoute::_('index.php');
			$msg = JText::_('Your orders alone can be viewed');
			$mainframe->redirect($link, $msg);
		} 
		
	
		
		//get order details , items
		$items = $model->getOrderDetails($order->order_id);
		
		//parse the trasaction details
		$txns= new JParameter($order->transaction_details);
		
		//get address
		
		$address = &$this->get('ShippingAddress', 'address');
		
		$print = JRequest::getBool('print');
		if ($print) {
			$document->setMetaData('robots', 'noindex, nofollow');
		}
	
		//set breadcrumbs
		
		$pathway->addItem($order->order_id, '');
		
		$this->assignRef('order',		$order);
		$this->assignRef('items',		$items);
		$this->assignRef('txns',		$txns);
		$this->assignRef('address',		$address);
		$this->assignRef('params',		$params);
		
		parent::display($tpl);
	}
	
	

}
?>