<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

//print_r($this->params); 
?>

<div id="k2store_order_item">

<fieldset>

	

	<table class="userTable" width="100%">
	
		<tr>
		
		<td colspan="2" align="right" width="100%" class="buttonheading">
		<?php echo JHTML::_('icon.print_screen',  $this->order, $this->params); ?>
		</td>
		
		</tr>
	
		<tr><td width="50%">
		
		<h3><?php echo JText::_('Order Summary'); ?></h3>	
		<!-- begin order summary -->
		<table class="orderTable">
		
		<tr>
			<td><?php echo JText::_('Invoice No'); ?> : </td>
			<td><?php echo $this->order->id; ?> </td>
		</tr>
		<tr>
			<td><?php echo JText::_('Unique Order ID'); ?> : </td>
			<td><?php echo $this->order->order_id; ?> </td>
		</tr>
		
		<tr>
			<td><?php echo JText::_('Order Value'); ?> : </td>
			<td><?php echo number_format($this->order->orderpayment_amount, 2); ?> </td>
		</tr>
		<tr>
			<td><?php echo JText::_('Order Date'); ?> : </td>
			<td><?php echo $this->order->created_date; ?> </td>
		</tr>
		
		<tr>
			<td><?php echo JText::_('Order Status'); ?> : </td>
			<td><?php echo $this->order->transaction_status; ?> </td>
		</tr>
	</table>
	</td>
	<!-- end of order summery -->
	
	<!-- begin payment summary -->
	<td width="50%">
	<h3><?php echo JText::_('Payment Summary'); ?></h3>
		
	<table class="paymentTable">
		
		<tr>
			<td><?php echo JText::_('Payment Type'); ?> : </td>
			<td><?php echo $this->order->orderpayment_type; ?> </td>
		</tr>
		
		<tr>
			<td><?php echo JText::_('Transaction ID'); ?> : </td>
			<td><?php echo $this->txns->get('txn_id'); ?> </td>
		</tr>
		
		<tr>
			<td><?php echo JText::_('Payment Status'); ?> : </td>
			<td><?php echo $this->txns->get('payment_status'); ?> </td>
		</tr>
		
		<tr>
			<td><?php echo JText::_('Payment Date'); ?> : </td>
			<td><?php echo $this->txns->get('payment_date'); ?> </td>
		</tr>
		
	</table>
	
	</td></tr>
	<!-- end payment summary -->
		
	</table>

</fieldset>	

<fieldset>

	<legend><h3><?php echo JText::_('Order Details'); ?></h3></legend>

	<table class="orderDetailTable" width="100%">
	
	<thead>
		<th width="10%"><?php echo JText::_('Item ID'); ?></th>
		<th width="40%"><?php echo JText::_('Item Name'); ?></th>
		<th width="20%"><?php echo JText::_('Item Price'); ?> <?php echo '( '.$this->params->get('currency').' )'; ?></th>
		<th width="10%"><?php echo JText::_('Quantity'); ?></th>
		<th width="15%"><?php echo JText::_('Total'); ?><?php echo '( '.$this->params->get('currency').' )'; ?></th>	
	</thead>
	<tfoot> <tr>
				<td colspan="5" align="right" class="k2store_total">
				<?php echo JText::_('Grand Total');?>&nbsp; : 
				<?php echo $this->params->get('currency'); ?>
				<?php echo number_format($this->order->orderpayment_amount, 2); ?>
				</td>
			</tr> 
	</tfoot>	
	
	<tbody>
	<?php
			for($i=0; $i<count($this->items); $i++) {
				$item = $this->items[$i];
			?>	
		
		<tr>
			<td><?php echo $item->itemid; ?> </td>
			<td><?php echo $item->itemname; ?> </td>
			<td><?php echo $item->itemprice; ?> </td>
			<td><?php echo $item->quantity; ?> </td>
			<td><?php echo $item->total; ?> </td>
		</tr>
		<?php } ?>	
	</tbody>
	
	</table>

</fieldset>


<fieldset>

	<legend><h3><?php echo JText::_('Shipping Address'); ?></h3></legend>

	<table class="userTable" width="100%">
		<tr>
		  <td>
			<p><?php echo $this->address->first_name; ?> &nbsp; <?php echo $this->address->last_name; ?> </p>
			<p><?php echo $this->address->address_1; ?> </p>
			<p><?php echo $this->address->address_2; ?> </p>
			<p><?php echo $this->address->city; ?> </p>
			<p><?php echo $this->address->zip; ?> </p>
			<p></p><?php echo $this->address->state; ?> &nbsp; <?php echo $this->address->country; ?> </p>
			<p><?php echo $this->address->phone_1; ?> </p>
			<p><?php echo $this->address->phone_2; ?> </p>
			<p><?php echo $this->address->fax; ?> </p>
			</td>
		</tr>
		
	</table>
	
</fieldset>			


</div>