//cart.js - k2store mootools 1.1 javascript

window.addEvent('domready', function(){

  //add event handler to the click on the 'remove' checkboxes on the checkout
  //the handler code makes an ajax call the the k2store component which deletes
  //the record from the database.
  $$('#cart tr .remove input').each(function(el){
    el.addEvent('click',function(e){
    	var orderCode = $(this).getValue();
    	var row = $(this).getParent().getParent();
      var myAjax = new Ajax('index.php?option=com_k2store&view=mycart&format=ajax', {
                              method: "get",
                              data:"remove[]=" + orderCode,
                              onSuccess: function(){
									     new Fx.Style(
									       row,
									       'color',
									       {duration:300,onComplete:function(){row.remove();calcPrice();}
									     }).start('#000000', '#fb6c6c'); 
          							},//onSuccess
          							onFailure: function() {
          							  window.location("index.php?option=com_k2store&view=mycart&format=ajax&remove[]="+orderCode);
          							}//onFailure
                            }).request();
    });//el.addevent
  });//$$(#cart tr .remove...

  //add event handler to the quantity input boxes on the checkout pages.
  //this handler makes an ajax call to the 
  $$('#cart tr .quantity input').each(function(el){
	   el.addEvent('change', function(e){
	     //get the table row of the product item
        var row = $(this).getParent().getParent(); 
        //convert quantity input to a number (zero if not a number)
        var q = $(this).value;
        if (q=='') q=0;
        var quantity = isNaN(q) ? 0 : parseInt(q); 
        //get the product code of the item that has changed
        var orderCode = row.getElement('td.order_code').getText();
        if (quantity!=0) {
          //quantity is not zero..so setup the ajax call
          var myAjax = new Ajax(
            'index.php?option=com_k2store&view=mycart&format=ajax',
            {
              method: 'get',
              data: 'quantity[' + orderCode + ']=' + quantity,
              //when the request is made, turn the row text colour RED
              onRequest: function(){new Fx.Style(row,'color',{duration:300}).start('#000000', '#fb6c6c');},
              //when ajax call successful, turn the text colour of the row back to black
              //and update the prices/totals/etc. 
              onSuccess: function(response){
                //start the effect
                new Fx.Style(
					   row,
					   'color',
					   {duration:300}
					 ).start('#fb6c6c', '#000000');
					 //re-calculate the price subtotals and totals
					 calcPrice();					 
				  },//onSuccess
				  //if ajax call fails, then force a page refresh straight to com_k2store
              onFailure: function(){
                  window.location("index.php?option=com_k2store&view=mycart&format=ajax&quantity[" + orderCode + "]=" + quantity);
              }//onFailure
            }
          ).request();//var myAjax
        }//if quantity
    });//el.addEvent
  });//#cart tr .quantity...

});//window.addevent

function calcPrice() {
  var totalPrice = 0;
  //loop through all the rows in the cart table
  $$('tr.cartline').each(function(el){
    //pull out the quantity of items
    var q = el.getElement('td input[name^=quantity]').value;  //get first input in row that name starts with quantity
    var quantity = isNaN(q) ? 0 : parseInt(q);             //clean-up quantity; from textbox input to integer
    var itemprice = el.getElement('td span[class=just_unit_price]').getText();
    var order_code = el.getElement('td[class=order_code]').getText();

    //calculate the sub-total and running total prices
    var extendedprice = quantity * itemprice;
    totalPrice += extendedprice;
    
    //write updated subtotal price to the document 
    el.getElement('td span[class=just_ext_price]').setText(extendedprice);
  });//$$(#cart td..
  //now, output the total price
  $('total_price').getElement('span').setText(totalPrice);
  
  if (totalPrice==0) {
    $('cart').getParent().setHTML("<p class='center'>You have no items in your cart.</p>");
  }
}//function calcPrice
