<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class Shopping_Cart {
	var $cart_name;       // The name of the cart/session variable
	var $items = array(); // The array for storing items in the cart
	
	/**
	 * __construct() - Constructor. This assigns the name of the cart
	 *                 to an instance variable and loads the cart from
	 *                 session.
	 *
	 * @param string $name The name of the cart.
	 */
	function __construct($name) {
		$this->cart_name = $name;
		
		$session = JFactory::getSession();
		//$this->items = $_SESSION[$this->cart_name];
		$this->items = $session->get($this->cart_name); 
		
	}
	
	/**
	 * setItemQuantity() - Set the quantity of an item.
	 *
	 * @param string $order_code The order code of the item.
	 * @param int $quantity The quantity.
	 */
	function setItemQuantity($order_code, $quantity) {
		$this->items[$order_code] = $quantity;
	}
	
		
	/**
	 * getItems() - Get all items.
	 *
	 * @return array The items.
	 */
	function getItems() {
		return $this->items;
	}
	
	/**
	 * hasItems() - Checks to see if there are items in the cart.
	 *
	 * @return bool True if there are items.
	 */
	function hasItems() {
		return (bool) $this->items;
	}
	
	/**
	 * getItemQuantity() - Get the quantity of an item in the cart.
	 *
	 * @param string $order_code The order code.
	 * @return int The quantity.
	 */
	function getItemQuantity($order_code) {
		return (int) $this->items[$order_code];
	}
	
	/**
	 * clean() - Cleanup the cart contents. If any items have a
	 *           quantity less than one, remove them.
	 */
	function clean() {
	
	if ($this->items) {
		foreach ( $this->items as $order_code=>$quantity ) {
			if ( $quantity < 1 )
				unset($this->items[$order_code]);
		}
	 }
	
	}
	
	/**
	 * save() - Saves the cart to a session variable.
	 */
	function save() {
		$this->clean();
		$session = JFactory::getSession();
		$session->set($this->cart_name, $this->items); 
	}
	
	
}
?>