<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class K2StoreOrdersHelper {
	
	
	  function sendUserEmail($user_id, $order_id, $payment_status, $order_status)
    {
        $mainframe =& JFactory::getApplication();
                
        // grab config settings for sender name and email
        $config     = &JComponentHelper::getParams('com_k2store');
        $mailfrom   = $config->get( 'emails_defaultemail', $mainframe->getCfg('mailfrom') );
        $fromname   = $config->get( 'emails_defaultname', $mainframe->getCfg('fromname') );
        $sitename   = $config->get( 'sitename', $mainframe->getCfg('sitename') );
        $siteurl    = $config->get( 'siteurl', JURI::root() );
        $ourl = $siteurl.'index.php?option=com_k2store&view=orders&id='.$order_id;
        
        
        $recipient = K2StoreOrdersHelper::_getUser($user_id);
        $mailer =& JFactory::getMailer();
        $mode = 1;
        
        $subject = JText::sprintf('ORDER USER EMAIL SUB', $recipient->name, $sitename);
        
        $msg = '';
        $msg .= JText::sprintf('ORDER PLACED SUCCESS', $recipient->name, $sitename, $ourl, $payment_status);
        
        //send attachments as well
        
        //allow_attachment_downloads
        
        //attachements
        
        //send attachments, only when the order state is confirmed and attachments are allowed
        if ($config->get('allow_attachment_downloads'))  {      
	        if (trim(strtolower($order_status)) == 'confirmed') {
			
	        $attachments = K2StoreOrdersHelper::getAttachments($order_id);
			if (count($attachments)>0) {
				$msg .='<br />----------------------------------------------------------------------------------------------------------- <br />';
				$msg .= JText::_('The attached file(s) to this email').': <br />';
				foreach($attachments as $attachment) {
					$msg .= 'File: '.$attachment->filename.'<br />';
					$att = JPATH_ROOT.DS.'media'.DS.'k2'.DS.'attachments'.DS.$attachment->filename;
					$mailer->addAttachment($att);
				}//foreach
			}//if count
	        
			}
		}       
        
	  

        if ($recipient) 
        {           
            $mailer->addRecipient( $recipient->email);
            $mailer->setSubject( $subject );
            $mailer->setBody($msg);
            $mailer->IsHTML($mode);          
            $mailer->setSender(array( $mailfrom, $fromname ));
            $sent = $mailer->send();
        }

        return true;
    }
    
    
    
    function _getUser($uid)
    {
        $db =& JFactory::getDBO();
        $q = "SELECT name, email FROM #__users "
           . "WHERE id = {$uid}"
           ;
        $db->setQuery($q);
        $user_email = $db->loadObject();
            
        if ($error = $db->getErrorMsg()) {
            JError::raiseError(500, $error);
            return false;
        }
        
        return $user_email;               
    }
    
    
    function getAttachments($order) {

		global $mainframe;
		$db =& JFactory::getDBO();
 		$all_attachments = Array(); 

		//get all the items for this order
		$query = "SELECT * FROM #__k2store_orderdetails WHERE order_id=".$order;
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		//if no items found then exit now!
		if ($items==0) {
		  return $all_attachments;  //return empty array
		}

		//loop through items, generating a list of attachments
		foreach($items as $item) {
			$sql = "SELECT * FROM #__k2_attachments WHERE itemID =".$item->itemid;
			$db->setQuery( $sql );
			$attachments = $db->loadObjectList();
			//accumulate all attachments into one big array
		  $all_attachments = array_merge($all_attachments, (array)$attachments);
		}//foreach
		
		//ok, all done - return the resulting array of attachments
		return $all_attachments;		
	}//function getOrderAttachments

   
}
?>